/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.NotInBranchStateHandler;
import com.atomikos.datasource.xa.session.TerminatedStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import javax.transaction.xa.XAResource;

class TransactionContext {
    private TransactionContextStateHandler state;

    TransactionContext(XATransactionalResource resource, XAResource xaResource) {
        this.setState(new NotInBranchStateHandler(resource, xaResource));
    }

    private synchronized void setState(TransactionContextStateHandler state) {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": changing to state " + state);
        }
        if (state != null) {
            this.state = state;
        }
    }

    synchronized boolean isTerminated() {
        return this.state instanceof TerminatedStateHandler;
    }

    synchronized void checkEnlistBeforeUse(CompositeTransaction ct, HeuristicMessage hmsg) throws InvalidSessionHandleStateException, UnexpectedTransactionContextException {
        TransactionContextStateHandler nextState = this.state.checkEnlistBeforeUse(ct, hmsg);
        this.setState(nextState);
    }

    synchronized void sessionClosed() {
        TransactionContextStateHandler nextState = this.state.sessionClosed();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(this + ": changing state to " + nextState);
        }
        this.setState(nextState);
    }

    synchronized void transactionSuspended() throws InvalidSessionHandleStateException {
        TransactionContextStateHandler nextState = this.state.transactionSuspended();
        this.setState(nextState);
    }

    synchronized void transactionResumed() throws InvalidSessionHandleStateException {
        TransactionContextStateHandler nextState = this.state.transactionResumed();
        this.setState(nextState);
    }

    synchronized void transactionTerminated(CompositeTransaction ct) {
        TransactionContextStateHandler nextState = this.state.transactionTerminated(ct);
        this.setState(nextState);
    }

    synchronized boolean isSuspendedInTransaction(CompositeTransaction ct) {
        return this.state.isSuspendedInTransaction(ct);
    }

    public String toString() {
        return "a TransactionContext";
    }

    boolean isInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isInTransaction(tx);
        }
        return ret;
    }

    boolean isInactiveInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.state != null) {
            ret = this.state.isInactiveInTransaction(tx);
        }
        return ret;
    }
}

