/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.jta.RemoteClientUserTransaction;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.icatch.system.Configuration;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionServerImp
implements UserTransactionServer {
    private static UserTransactionServerImp singleton_ = null;
    private TransactionManagerImp tm_;
    private String name_ = "UserTransactionServer";
    private boolean exported_ = false;
    private String initialContextFactory_;
    private String providerUrl_;
    private Properties properties_;

    public static synchronized UserTransactionServerImp getSingleton() {
        if (singleton_ == null) {
            singleton_ = new UserTransactionServerImp();
        }
        return singleton_;
    }

    private UserTransactionServerImp() {
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        Enumeration<?> enumm = this.properties_.propertyNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String value = this.properties_.getProperty(name);
            env.put(name, value);
        }
        return new InitialContext(env);
    }

    public UserTransaction getUserTransaction() {
        RemoteClientUserTransaction ret = null;
        if (this.exported_) {
            ret = new RemoteClientUserTransaction(this.getName(), this.initialContextFactory_, this.providerUrl_);
        }
        return ret;
    }

    public String getName() {
        return this.name_;
    }

    public void init(String tmUniqueName, Properties properties) throws SysException {
        boolean canExport = false;
        String exportClass = properties.getProperty("com.atomikos.icatch.rmi_export_class");
        boolean bl = canExport = "UnicastRemoteObject".equals(exportClass) || "PortableRemoteObject".equals(exportClass);
        if (!canExport) {
            Configuration.logWarning("Client transaction demarcation not supported for com.atomikos.icatch.rmi_export_class=" + exportClass);
            this.exported_ = false;
        } else {
            this.name_ = tmUniqueName + "UserTransactionServer";
            this.providerUrl_ = properties.getProperty("java.naming.provider.url");
            if (this.providerUrl_ == null) {
                throw new SysException("Startup property java.naming.provider.url must be set for client demarcation.");
            }
            this.initialContextFactory_ = properties.getProperty("java.naming.factory.initial");
            if (this.initialContextFactory_ == null) {
                throw new SysException("Startup property java.naming.factory.initial must be set for client demarcation.");
            }
            this.properties_ = properties;
            this.tm_ = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
            if (this.tm_ == null) {
                throw new SysException("No TM found");
            }
            try {
                if ("PortableRemoteObject".equals(exportClass)) {
                    PortableRemoteObject.exportObject((Remote)this);
                    this.exported_ = true;
                } else if ("UnicastRemoteObject".equals(exportClass)) {
                    UnicastRemoteObject.exportObject(this);
                    this.exported_ = true;
                }
            }
            catch (Exception e) {
                Stack<Exception> errors = new Stack<Exception>();
                errors.push(e);
                throw new SysException("Error exporting - naming service not running?", errors);
            }
            try {
                Context ctx = this.getInitialContext();
                ctx.rebind(this.name_, (Object)this);
            }
            catch (Exception e) {
                Stack<Exception> errors = new Stack<Exception>();
                errors.push(e);
                throw new SysException("Please make sure the rmiregistry is running!?", errors);
            }
        }
    }

    public void shutdown() throws SysException {
        if (this.exported_) {
            String exportClass = this.properties_.getProperty("com.atomikos.icatch.rmi_export_class");
            try {
                if ("PortableRemoteObject".equals(exportClass)) {
                    PortableRemoteObject.unexportObject((Remote)this);
                } else if ("UnicastRemoteObject".equals(exportClass)) {
                    UnicastRemoteObject.unexportObject(this, true);
                }
                Context ctx = this.getInitialContext();
                ctx.unbind(this.name_);
            }
            catch (Exception e) {
                Stack<Exception> errors = new Stack<Exception>();
                errors.push(e);
                throw new SysException(e.getMessage(), errors);
            }
            this.exported_ = false;
        }
    }

    public String begin(int timeout) throws RemoteException, SystemException, NotSupportedException {
        this.tm_.begin(timeout);
        TransactionImp tx = (TransactionImp)this.tm_.getTransaction();
        tx.getCT().getTransactionControl().setSerial();
        this.tm_.suspend();
        return tx.getCT().getTid();
    }

    public void commit(String tid) throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImp tx = this.tm_.getPreviousInstance(tid);
        if (tx == null) {
            throw new RollbackException("Transaction not found: " + tid);
        }
        tx.commit();
    }

    public void rollback(String tid) throws RemoteException, IllegalStateException, SecurityException, SystemException {
        TransactionImp tx = this.tm_.getPreviousInstance(tid);
        if (tx != null) {
            tx.rollback();
        }
    }

    public void setRollbackOnly(String tid) throws RemoteException, IllegalStateException, SystemException {
        TransactionImp tx = this.tm_.getPreviousInstance(tid);
        if (tx != null) {
            tx.setRollbackOnly();
        }
    }

    public int getStatus(String tid) throws RemoteException, SystemException {
        int ret = 6;
        TransactionImp tx = this.tm_.getPreviousInstance(tid);
        if (tx != null) {
            ret = tx.getStatus();
        }
        return ret;
    }
}

