/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.extra.DestinationHelper;
import com.atomikos.jms.extra.MessageConsumerSessionProperties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

class MessageConsumerSession {
    private AtomikosConnectionFactoryBean factory;
    private String user;
    private String password;
    private Destination destination;
    private String destinationName;
    private MessageConsumerSessionProperties properties;
    private boolean notifyListenerOnClose;
    private String messageSelector;
    private boolean daemonThreads;
    private transient MessageListener listener;
    protected transient ReceiverThread current;
    private UserTransactionManager tm;
    private boolean active;
    private ExceptionListener exceptionListener;
    private boolean noLocal;
    private String subscriberName;
    private String clientID;

    protected MessageConsumerSession(MessageConsumerSessionProperties properties) {
        this.properties = properties;
        this.tm = new UserTransactionManager();
        this.noLocal = false;
        this.subscriberName = null;
    }

    protected String getSubscriberName() {
        return this.subscriberName;
    }

    protected void setSubscriberName(String name) {
        this.subscriberName = name;
    }

    protected void setNoLocal(boolean value) {
        this.noLocal = value;
    }

    protected boolean getNoLocal() {
        return this.noLocal;
    }

    protected void setAtomikosConnectionFactoryBean(AtomikosConnectionFactoryBean bean) {
        this.factory = bean;
    }

    protected AtomikosConnectionFactoryBean getAtomikosConnectionFactoryBean() {
        return this.factory;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public int getTransactionTimeout() {
        return this.properties.getTransactionTimeout();
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startListening() throws JMSException, SystemException {
        if (this.active) {
            throw new IllegalStateException("MessageConsumerSession: startListening() called a second time without stopListening() in between");
        }
        if (this.getDestinationName() == null) {
            throw new JMSException("Please set property 'destination' or 'destinationName' first");
        }
        if (this.factory == null) {
            throw new JMSException("Please set the ConnectionFactory first");
        }
        this.tm.setStartupTransactionService(true);
        this.tm.init();
        this.tm.setStartupTransactionService(false);
        this.active = true;
        this.startNewThread();
        StringBuffer msg = new StringBuffer();
        msg.append("MessageConsumerSession configured with [");
        msg.append("user=").append(this.getUser()).append(", ");
        msg.append("password=").append(this.password).append(", ");
        msg.append("transactionTimeout=").append(this.getTransactionTimeout()).append(", ");
        msg.append("destination=").append(this.getDestinationName()).append(", ");
        msg.append("notifyListenerOnClose= ").append(this.getNotifyListenerOnClose()).append(", ");
        msg.append("messageSelector=").append(this.getMessageSelector()).append(", ");
        msg.append("daemonThreads=").append(this.getDaemonThreads()).append(", ");
        msg.append("messageListener=").append(this.getMessageListener()).append(", ");
        msg.append("exceptionListener=").append(this.getExceptionListener()).append(", ");
        msg.append("connectionFactory=").append(this.getAtomikosConnectionFactoryBean());
        msg.append("]");
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug(msg.toString());
        }
    }

    public String getDestinationName() {
        String ret;
        block8: {
            ret = this.destinationName;
            if (ret == null) {
                if (this.destination instanceof Queue) {
                    Queue q = (Queue)this.destination;
                    try {
                        ret = q.getQueueName();
                    }
                    catch (JMSException e) {
                        if (Configuration.isDebugLoggingEnabled()) {
                            Configuration.logDebug("Error retrieving queue name", e);
                        }
                        break block8;
                    }
                }
                if (this.destination instanceof Topic) {
                    Topic t = (Topic)this.destination;
                    try {
                        ret = t.getTopicName();
                    }
                    catch (JMSException e) {
                        if (!Configuration.isDebugLoggingEnabled()) break block8;
                        Configuration.logDebug("Error retrieving topic name", e);
                    }
                }
            }
        }
        return ret;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected void startNewThread() {
        if (this.active) {
            this.current = new ReceiverThread();
            this.current.setDaemon(this.daemonThreads);
            this.current.start();
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug("MessageConsumerSession: started new thread: " + this.current);
            }
        }
    }

    private synchronized void notifyExceptionListener(JMSException e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e);
        }
    }

    public void stopListening() {
        if (this.current != null) {
            ReceiverThread t = this.current;
            this.current = null;
            t.closeJmsResources(true);
        }
        this.tm.close();
        this.active = false;
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public int getReceiveTimeout() {
        return this.properties.getReceiveTimeout();
    }

    class ReceiverThread
    extends Thread {
        private Connection connection;
        private Session session;

        private ReceiverThread() {
        }

        private synchronized MessageConsumer refreshJmsResources() throws JMSException {
            String subscriberName;
            Object ret = null;
            this.connection = MessageConsumerSession.this.user != null ? MessageConsumerSession.this.factory.createConnection(MessageConsumerSession.this.user, MessageConsumerSession.this.password) : MessageConsumerSession.this.factory.createConnection();
            if (MessageConsumerSession.this.clientID != null) {
                String connectionClientID = this.connection.getClientID();
                if (connectionClientID == null) {
                    this.connection.setClientID(MessageConsumerSession.this.clientID);
                } else {
                    Configuration.logWarning("Reusing connection with preset clientID: " + connectionClientID);
                }
            }
            this.connection.start();
            this.session = this.connection.createSession(true, 0);
            if (MessageConsumerSession.this.getDestination() == null) {
                Destination d = DestinationHelper.findDestination(MessageConsumerSession.this.getDestinationName(), this.session);
                MessageConsumerSession.this.setDestination(d);
            }
            ret = (subscriberName = MessageConsumerSession.this.getSubscriberName()) == null ? (MessageConsumerSession.this.destination instanceof Topic ? this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal()) : this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector())) : this.session.createDurableSubscriber((Topic)MessageConsumerSession.this.destination, subscriberName, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal());
            return ret;
        }

        private synchronized void closeJmsResources(boolean threadWillStop) {
            block22: {
                try {
                    block21: {
                        if (this.session != null) {
                            block20: {
                                if (threadWillStop) {
                                    try {
                                        Configuration.logWarning("MessageConsumerSession: unsubscribing " + MessageConsumerSession.this.subscriberName + "...");
                                        if (Thread.currentThread() != this) {
                                            if (Configuration.isInfoLoggingEnabled()) {
                                                Configuration.logInfo("MessageConsumerSession: waiting for listener thread to finish...");
                                            }
                                            this.join();
                                            if (Configuration.isDebugLoggingEnabled()) {
                                                Configuration.logDebug("MessageConsumerSession: waiting done.");
                                            }
                                        }
                                        if (MessageConsumerSession.this.subscriberName != null && MessageConsumerSession.this.properties.getUnsubscribeOnClose()) {
                                            Configuration.logWarning("MessageConsumerSession: unsubscribing " + MessageConsumerSession.this.subscriberName + "...");
                                            this.session.unsubscribe(MessageConsumerSession.this.subscriberName);
                                        }
                                    }
                                    catch (JMSException e) {
                                        if (Configuration.isInfoLoggingEnabled()) {
                                            Configuration.logInfo("MessageConsumerSession: Error closing on JMS session", e);
                                        }
                                        if (!Configuration.isInfoLoggingEnabled()) break block20;
                                        Configuration.logInfo("MessageConsumerSession: linked exception is ", e.getLinkedException());
                                    }
                                }
                            }
                            try {
                                if (Configuration.isInfoLoggingEnabled()) {
                                    Configuration.logInfo("MessageConsumerSession: closing JMS session...");
                                }
                                this.session.close();
                                this.session = null;
                                if (Configuration.isDebugLoggingEnabled()) {
                                    Configuration.logDebug("MessageConsumerSession: JMS session closed.");
                                }
                            }
                            catch (JMSException e) {
                                if (Configuration.isInfoLoggingEnabled()) {
                                    Configuration.logInfo("MessageConsumerSession: Error closing JMS session", e);
                                }
                                if (!Configuration.isInfoLoggingEnabled()) break block21;
                                Configuration.logInfo("MessageConsumerSession: linked exception is ", e.getLinkedException());
                            }
                        }
                    }
                    if (this.connection == null) break block22;
                    try {
                        if (Configuration.isInfoLoggingEnabled()) {
                            Configuration.logInfo("MessageConsumerSession: closing JMS connection...");
                        }
                        this.connection.close();
                        this.connection = null;
                        if (Configuration.isDebugLoggingEnabled()) {
                            Configuration.logDebug("MessageConsumerSession: JMS connection closed.");
                        }
                    }
                    catch (JMSException e) {
                        Configuration.logWarning("MessageConsumerSession: Error closing JMS connection", e);
                        Configuration.logWarning("MessageConsumerSession: linked exception is ", e.getLinkedException());
                    }
                }
                catch (Throwable e) {
                    Configuration.logWarning("MessageConsumerSession: Unexpected error during close: ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            MessageConsumer receiver = null;
            try {
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
            }
            catch (SystemException e) {
                Configuration.logWarning("MessageConsumerSession: Error in JMS thread while setting transaction timeout", e);
            }
            Configuration.logInfo("MessageConsumerSession: Starting JMS listener thread.");
            while (Thread.currentThread() == MessageConsumerSession.this.current) {
                Throwable fatal2222;
                SystemException err2222;
                Throwable e3222;
                Object var7_10;
                boolean commit;
                boolean refresh;
                block60: {
                    if (Configuration.isDebugLoggingEnabled()) {
                        Configuration.logDebug("MessageConsumerSession: JMS listener thread iterating...");
                    }
                    refresh = false;
                    commit = true;
                    Message msg = null;
                    if (receiver == null) {
                        receiver = this.refreshJmsResources();
                    }
                    MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
                    if (MessageConsumerSession.this.tm.getTransaction() != null) {
                        Configuration.logWarning("MessageConsumerSession: Detected pending transaction: " + MessageConsumerSession.this.tm.getTransaction());
                        throw new IllegalStateException("Can't reuse listener thread with pending transaction!");
                    }
                    MessageConsumerSession.this.tm.begin();
                    msg = receiver.receive((long)(MessageConsumerSession.this.getReceiveTimeout() * 1000));
                    try {
                        if (msg != null && MessageConsumerSession.this.listener != null && Thread.currentThread() == MessageConsumerSession.this.current) {
                            Configuration.logInfo("MessageConsumerSession: Consuming message: " + msg.toString());
                            MessageConsumerSession.this.listener.onMessage(msg);
                            Configuration.logDebug("MessageConsumerSession: Consumed message: " + msg.toString());
                        } else {
                            commit = false;
                        }
                    }
                    catch (Exception e22) {
                        if (Configuration.isInfoLoggingEnabled()) {
                            Configuration.logInfo("MessageConsumerSession: Error during JMS processing of message " + msg.toString() + " - rolling back.", e22);
                        }
                        commit = false;
                    }
                    var7_10 = null;
                    try {
                        if (commit) {
                            MessageConsumerSession.this.tm.commit();
                        } else {
                            MessageConsumerSession.this.tm.rollback();
                        }
                    }
                    catch (RollbackException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (HeuristicMixedException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (HeuristicRollbackException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (Throwable e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error ending thread tx association", e3222);
                        try {
                            Configuration.logDebug("MessageConsumerSession: Suspending any active transaction...");
                            MessageConsumerSession.this.tm.suspend();
                        }
                        catch (SystemException err2222) {
                            Configuration.logWarning("MessageConsumerSession: Error suspending transaction", err2222);
                            try {
                                Configuration.logDebug("MessageConsumerSession: Starting new thread...");
                                MessageConsumerSession.this.startNewThread();
                            }
                            catch (Throwable fatal2222) {
                                Configuration.logWarning("MessageConsumerSession: Error starting new thread - stopping listener", e3222);
                                MessageConsumerSession.this.stopListening();
                            }
                        }
                    }
                    if (!refresh || Thread.currentThread() != MessageConsumerSession.this.current) continue;
                    try {
                        receiver.close();
                    }
                    catch (Throwable e3222) {
                        if (!Configuration.isDebugLoggingEnabled()) break block60;
                        Configuration.logDebug("MessageConsumerSession: Error closing receiver", e3222);
                    }
                }
                receiver = null;
                this.closeJmsResources(false);
                {
                    continue;
                    catch (JMSException e4) {
                        block62: {
                            Configuration.logWarning("MessageConsumerSession: Error in JMS thread", e4);
                            Exception linkedException = e4.getLinkedException();
                            if (linkedException != null) {
                                Configuration.logWarning("Linked JMS exception is: ", linkedException);
                            }
                            refresh = true;
                            commit = false;
                            MessageConsumerSession.this.notifyExceptionListener(e4);
                            var7_10 = null;
                            try {
                                if (commit) {
                                    MessageConsumerSession.this.tm.commit();
                                } else {
                                    MessageConsumerSession.this.tm.rollback();
                                }
                            }
                            catch (RollbackException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (HeuristicMixedException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (HeuristicRollbackException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (Throwable e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error ending thread tx association", e3222);
                                try {
                                    Configuration.logDebug("MessageConsumerSession: Suspending any active transaction...");
                                    MessageConsumerSession.this.tm.suspend();
                                }
                                catch (SystemException err2222) {
                                    Configuration.logWarning("MessageConsumerSession: Error suspending transaction", err2222);
                                    try {
                                        Configuration.logDebug("MessageConsumerSession: Starting new thread...");
                                        MessageConsumerSession.this.startNewThread();
                                    }
                                    catch (Throwable fatal2222) {
                                        Configuration.logWarning("MessageConsumerSession: Error starting new thread - stopping listener", e3222);
                                        MessageConsumerSession.this.stopListening();
                                    }
                                }
                            }
                            if (!refresh || Thread.currentThread() != MessageConsumerSession.this.current) continue;
                            try {
                                receiver.close();
                            }
                            catch (Throwable e3222) {
                                if (!Configuration.isDebugLoggingEnabled()) break block62;
                                Configuration.logDebug("MessageConsumerSession: Error closing receiver", e3222);
                            }
                        }
                        receiver = null;
                        this.closeJmsResources(false);
                        continue;
                    }
                    catch (Throwable e5) {
                        block64: {
                            Configuration.logWarning("MessageConsumerSession: Error in JMS thread", e5);
                            refresh = true;
                            commit = false;
                            JMSException listenerError = new JMSException("Unexpected error - please see Atomikos console file for more info");
                            MessageConsumerSession.this.notifyExceptionListener(listenerError);
                            var7_10 = null;
                            try {
                                if (commit) {
                                    MessageConsumerSession.this.tm.commit();
                                } else {
                                    MessageConsumerSession.this.tm.rollback();
                                }
                            }
                            catch (RollbackException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (HeuristicMixedException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (HeuristicRollbackException e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                            }
                            catch (Throwable e3222) {
                                Configuration.logWarning("MessageConsumerSession: Error ending thread tx association", e3222);
                                try {
                                    Configuration.logDebug("MessageConsumerSession: Suspending any active transaction...");
                                    MessageConsumerSession.this.tm.suspend();
                                }
                                catch (SystemException err2222) {
                                    Configuration.logWarning("MessageConsumerSession: Error suspending transaction", err2222);
                                    try {
                                        Configuration.logDebug("MessageConsumerSession: Starting new thread...");
                                        MessageConsumerSession.this.startNewThread();
                                    }
                                    catch (Throwable fatal2222) {
                                        Configuration.logWarning("MessageConsumerSession: Error starting new thread - stopping listener", e3222);
                                        MessageConsumerSession.this.stopListening();
                                    }
                                }
                            }
                            if (!refresh || Thread.currentThread() != MessageConsumerSession.this.current) continue;
                            try {
                                receiver.close();
                            }
                            catch (Throwable e3222) {
                                if (!Configuration.isDebugLoggingEnabled()) break block64;
                                Configuration.logDebug("MessageConsumerSession: Error closing receiver", e3222);
                            }
                        }
                        receiver = null;
                        this.closeJmsResources(false);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    try {
                        if (commit) {
                            MessageConsumerSession.this.tm.commit();
                        } else {
                            MessageConsumerSession.this.tm.rollback();
                        }
                    }
                    catch (RollbackException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (HeuristicMixedException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (HeuristicRollbackException e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error in ending transaction", e3222);
                    }
                    catch (Throwable e3222) {
                        Configuration.logWarning("MessageConsumerSession: Error ending thread tx association", e3222);
                        try {
                            Configuration.logDebug("MessageConsumerSession: Suspending any active transaction...");
                            MessageConsumerSession.this.tm.suspend();
                        }
                        catch (SystemException err2222) {
                            Configuration.logWarning("MessageConsumerSession: Error suspending transaction", err2222);
                            try {
                                Configuration.logDebug("MessageConsumerSession: Starting new thread...");
                                MessageConsumerSession.this.startNewThread();
                            }
                            catch (Throwable fatal2222) {
                                Configuration.logWarning("MessageConsumerSession: Error starting new thread - stopping listener", e3222);
                                MessageConsumerSession.this.stopListening();
                            }
                        }
                    }
                    if (refresh && Thread.currentThread() == MessageConsumerSession.this.current) {
                        block66: {
                            try {
                                receiver.close();
                            }
                            catch (Throwable e3222) {
                                if (!Configuration.isDebugLoggingEnabled()) break block66;
                                Configuration.logDebug("MessageConsumerSession: Error closing receiver", e3222);
                            }
                        }
                        receiver = null;
                        this.closeJmsResources(false);
                    }
                    throw throwable;
                }
            }
            Configuration.logInfo("MessageConsumerSession: JMS listener thread exiting.");
            if (MessageConsumerSession.this.listener != null && MessageConsumerSession.this.current == null && MessageConsumerSession.this.notifyListenerOnClose) {
                MessageConsumerSession.this.listener.onMessage(null);
            }
        }
    }
}

