/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.TerminatedStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class BranchEndedStateHandler
extends TransactionContextStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(BranchEndedStateHandler.class);
    private CompositeTransaction ct;

    BranchEndedStateHandler(XATransactionalResource resource, XAResourceTransaction branch, CompositeTransaction ct) {
        super(resource, null);
        this.ct = ct;
        branch.suspend();
    }

    TransactionContextStateHandler checkEnlistBeforeUse(CompositeTransaction ct, HeuristicMessage hmsg) throws InvalidSessionHandleStateException {
        String msg = "Detected illegal attempt to use a closed XA session";
        LOGGER.logWarning(msg);
        throw new InvalidSessionHandleStateException(msg);
    }

    TransactionContextStateHandler sessionClosed() {
        return null;
    }

    TransactionContextStateHandler transactionTerminated(CompositeTransaction tx) {
        TerminatedStateHandler ret = null;
        if (this.ct.isSameTransaction(tx)) {
            ret = new TerminatedStateHandler();
        }
        return ret;
    }

    boolean isInactiveInTransaction(CompositeTransaction tx) {
        return this.ct.isSameTransaction(tx);
    }
}

