/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.SiblingMapper;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XID;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class XATransactionalResource
implements TransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(XATransactionalResource.class);
    protected XAResource xares_;
    protected String servername_;
    protected Hashtable recoveredXidMap_;
    protected Hashtable rootTransactionToSiblingMapperMap_;
    protected XidFactory xidFact_;
    private boolean closed_;
    private boolean weakCompare_;
    private boolean compareAlwaysTrue_;
    private String branchIdentifier;
    private static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final int MAX_LONG_LEN = MAX_LONG_STR.getBytes().length;

    public XATransactionalResource(String servername) {
        this.servername_ = servername;
        this.rootTransactionToSiblingMapperMap_ = new Hashtable();
        if (servername.getBytes().length > 64 - MAX_LONG_LEN) {
            throw new RuntimeException("Max length of resource name exceeded: should be less than " + (64 - MAX_LONG_LEN));
        }
        this.xidFact_ = new DefaultXidFactory();
        this.closed_ = false;
        this.weakCompare_ = false;
        this.compareAlwaysTrue_ = false;
    }

    public XATransactionalResource(String servername, XidFactory factory) {
        this(servername);
        this.xidFact_ = factory;
    }

    protected abstract XAResource refreshXAConnection() throws ResourceException;

    public XidFactory getXidFactory() {
        return this.xidFact_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiblingMap(String root) {
        Hashtable hashtable = this.rootTransactionToSiblingMapperMap_;
        synchronized (hashtable) {
            this.rootTransactionToSiblingMapperMap_.remove(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SiblingMapper getSiblingMap(String root) {
        Hashtable hashtable = this.rootTransactionToSiblingMapperMap_;
        synchronized (hashtable) {
            if (this.rootTransactionToSiblingMapperMap_.containsKey(root)) {
                return (SiblingMapper)this.rootTransactionToSiblingMapperMap_.get(root);
            }
            SiblingMapper map = new SiblingMapper(this, root);
            this.rootTransactionToSiblingMapperMap_.put(root, map);
            return map;
        }
    }

    protected boolean needsRefresh() {
        boolean ret;
        block3: {
            ret = true;
            try {
                if (this.xares_ != null) {
                    this.xares_.isSameRM(this.xares_);
                    ret = false;
                }
            }
            catch (XAException xa) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.logDebug(this.servername_ + ": XAResource needs refresh?", xa);
            }
        }
        return ret;
    }

    public void useWeakCompare(boolean weakCompare) {
        this.weakCompare_ = weakCompare;
    }

    public boolean usesWeakCompare() {
        return this.weakCompare_;
    }

    public void setAcceptAllXAResources(boolean val) {
        this.compareAlwaysTrue_ = val;
    }

    public boolean acceptsAllXAResources() {
        return this.compareAlwaysTrue_;
    }

    public boolean usesXAResource(XAResource xares) {
        if (this.acceptsAllXAResources()) {
            return true;
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            return false;
        }
        boolean ret = false;
        if (!xares.getClass().getName().equals(xaresource.getClass().getName())) {
            ret = false;
        } else {
            try {
                if (xares.isSameRM(xaresource)) {
                    ret = true;
                } else if (this.usesWeakCompare()) {
                    ret = true;
                } else {
                    LOGGER.logDebug("XAResources claim to be different: " + xares + " and " + xaresource);
                }
            }
            catch (XAException xe) {
                Stack<Exception> errors = new Stack<Exception>();
                errors.push(xe);
                throw new SysException("Error in XAResource comparison: " + xe.getMessage(), errors);
            }
        }
        return ret;
    }

    public synchronized XAResource getXAResource() {
        if (this.needsRefresh()) {
            LOGGER.logDebug(this.servername_ + ": refreshing XAResource...");
            this.xares_ = this.refreshXAConnection();
            LOGGER.logInfo(this.servername_ + ": refreshed XAResource");
        }
        return this.xares_;
    }

    @Override
    public ResourceTransaction getResourceTransaction(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (ct == null) {
            return null;
        }
        Stack<CompositeTransaction> lineage = ct.getLineage();
        String root = null;
        if (lineage == null || lineage.isEmpty()) {
            root = ct.getTid();
        } else {
            Stack tmp = (Stack)lineage.clone();
            while (!tmp.isEmpty()) {
                CompositeTransaction next = (CompositeTransaction)tmp.pop();
                if (!next.isRoot()) continue;
                root = next.getTid();
            }
        }
        return this.getSiblingMap(root).findOrCreateBranchForTransaction(ct);
    }

    @Override
    public String getName() {
        return this.servername_;
    }

    @Override
    public void close() throws ResourceException {
        this.closed_ = true;
    }

    @Override
    public boolean isClosed() throws ResourceException {
        return this.closed_;
    }

    @Override
    public boolean isSameRM(RecoverableResource res) throws ResourceException {
        if (res == null || !(res instanceof XATransactionalResource)) {
            return false;
        }
        XATransactionalResource xatxres = (XATransactionalResource)res;
        if (xatxres.servername_ == null || this.servername_ == null) {
            return false;
        }
        return xatxres.servername_.equals(this.servername_);
    }

    @Override
    public void setRecoveryService(RecoveryService recoveryService) throws ResourceException {
        if (recoveryService != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Installing recovery service on resource " + this.getName());
            }
            this.branchIdentifier = recoveryService.getName();
            recoveryService.recover();
        }
    }

    @Override
    public synchronized boolean recover(Participant participant) throws ResourceException {
        boolean recovered = true;
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (!(participant instanceof XAResourceTransaction)) {
            throw new ResourceException("Wrong argument class: " + participant.getClass().getName());
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            LOGGER.logWarning("XATransactionalResource " + this.getName() + ": XAResource is null");
            return false;
        }
        XAResourceTransaction xarestx = (XAResourceTransaction)participant;
        this.recoverXidsFromResourceIfNecessary();
        if (!this.recoveredXidMap_.containsKey(xarestx.getXid())) {
            recovered = false;
        }
        if (recovered || this.getName().equals(xarestx.getResourceName())) {
            xarestx.setRecoveredXAResource(this.getXAResource());
            xarestx.setResource(this);
        }
        this.recoveredXidMap_.remove(xarestx.getXid());
        return recovered;
    }

    protected void recover() throws ResourceException {
        this.recoveredXidMap_ = new Hashtable();
        Xid[] recoveredlist = null;
        int flags = 0x1000000;
        boolean allXidsFromResourceHaveBeenRecovered = false;
        Stack errors = new Stack();
        Vector<Xid> recoveredXids = new Vector<Xid>();
        if (this.branchIdentifier == null) {
            LOGGER.logDebug("No recoveryService set yet!");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("recovery initiated for resource " + this.getName() + " with branchIdentifier " + this.branchIdentifier);
        }
        do {
            recoveredlist = this.recoverXidsFromXAResource(flags, errors);
            flags = 0;
            boolean bl = allXidsFromResourceHaveBeenRecovered = recoveredlist == null || recoveredlist.length == 0;
            if (allXidsFromResourceHaveBeenRecovered) continue;
            allXidsFromResourceHaveBeenRecovered = true;
            for (Xid vendorXid : recoveredlist) {
                Xid xid = this.wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(vendorXid);
                if (!this.notAlreadyRecovered(recoveredXids, xid)) continue;
                allXidsFromResourceHaveBeenRecovered = false;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("Resource " + this.servername_ + " inspecting XID: " + xid);
                }
                recoveredXids.addElement(xid);
                String branch = new String(vendorXid.getBranchQualifier());
                if (branch.startsWith(this.branchIdentifier)) {
                    this.recoveredXidMap_.put(xid, new Object());
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.logInfo("Resource " + this.servername_ + " recovering XID: " + xid);
                    continue;
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.logInfo("Resource " + this.servername_ + ": XID " + xid + " with branch " + branch + " is not under my responsibility");
            }
        } while (!allXidsFromResourceHaveBeenRecovered);
        recoveredXids = null;
    }

    private boolean notAlreadyRecovered(Vector recoveredXids, Xid xid) {
        return !recoveredXids.contains(xid);
    }

    private Xid[] recoverXidsFromXAResource(int flags, Stack errors) {
        Xid[] recoveredlist = null;
        try {
            recoveredlist = this.getXAResource().recover(flags);
        }
        catch (NullPointerException ora) {
            if (this.getXAResource().getClass().getName().toLowerCase().indexOf("oracle") >= 0) {
                LOGGER.logWarning("ORACLE NOT CONFIGURED FOR XA? PLEASE CONTACT YOUR DBA TO FIX THIS...");
            }
            throw ora;
        }
        catch (XAException xaerr) {
            LOGGER.logWarning("Error in recovery", xaerr);
            errors.push(xaerr);
            throw new ResourceException("Error in recovery", errors);
        }
        return recoveredlist;
    }

    private Xid wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(Xid xid) {
        return new XID(xid);
    }

    @Override
    public void endRecovery() throws ResourceException {
        if (this.closed_) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (this.getXAResource() != null) {
            this.recoverXidsFromResourceIfNecessary();
            this.performPresumedAbortForRemainingXids();
        }
        this.resetForNextRecoveryScan();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("endRecovery() done for resource " + this.getName());
        }
    }

    private void performPresumedAbortForRemainingXids() {
        Enumeration toAbortList = this.recoveredXidMap_.keys();
        XAResource xaresource = this.getXAResource();
        while (toAbortList.hasMoreElements()) {
            XID xid = (XID)toAbortList.nextElement();
            try {
                xaresource.rollback(xid);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.logInfo("XAResource.rollback ( " + xid + " ) called " + "on resource " + this.servername_);
            }
            catch (XAException xaerr) {}
        }
    }

    private void resetForNextRecoveryScan() {
        this.recoveredXidMap_ = null;
    }

    private void recoverXidsFromResourceIfNecessary() {
        if (this.recoveredXidMap_ == null) {
            this.recover();
        }
    }

    public void setXidFactory(XidFactory factory) {
        this.xidFact_ = factory;
    }

    protected Xid createXid(String tid) {
        if (this.branchIdentifier == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return this.getXidFactory().createXid(tid, this.branchIdentifier);
    }
}

