/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private static final long serialVersionUID = 4796496938014754464L;
    private String meAsString_;
    private int formatId_;
    private int branchUsed_ = 0;
    private int globalUsed_ = 0;
    private byte[] branchQualifier_ = new byte[64];
    private byte[] globalTransactionId_ = new byte[64];
    private static final int DEFAULT_FORMAString = 1096044365;

    private XID(String tid) {
        this.formatId_ = 1096044365;
        this.branchQualifier_[0] = 0;
        this.branchUsed_ = 1;
        this.globalTransactionId_ = tid.toString().getBytes();
        this.globalUsed_ = tid.toString().getBytes().length;
    }

    public XID(String tid, String resourceURL) {
        this(tid);
        this.branchQualifier_ = resourceURL.getBytes();
        this.branchUsed_ = this.branchQualifier_.length;
        if (this.branchQualifier_.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded.");
        }
        if (this.globalUsed_ > 64) {
            throw new RuntimeException("Max global tid length exceeded.");
        }
    }

    public XID(Xid xid) {
        this.formatId_ = xid.getFormatId();
        this.globalTransactionId_ = xid.getGlobalTransactionId();
        this.globalUsed_ = xid.getGlobalTransactionId().length;
        this.branchQualifier_ = xid.getBranchQualifier();
        this.branchUsed_ = xid.getBranchQualifier().length;
    }

    @Override
    public int getFormatId() {
        return this.formatId_;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier_;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId_;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Xid xid = (Xid)obj;
        return Arrays.equals(xid.getGlobalTransactionId(), this.getGlobalTransactionId()) && Arrays.equals(xid.getBranchQualifier(), this.getBranchQualifier());
    }

    public String toString() {
        if (this.meAsString_ == null) {
            this.meAsString_ = new String(this.getGlobalTransactionId()) + new String(this.getBranchQualifier());
        }
        return this.meAsString_;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

