/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransactionMBean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class JmxTransaction
implements JmxTransactionMBean,
MBeanRegistration {
    private AdminTransaction adminTransaction;
    private MBeanServer server;
    private ObjectName name;

    protected static String convertState(int state) {
        String ret = "UNKNOWN";
        switch (state) {
            case -3: {
                ret = "ACTIVE";
                break;
            }
            case -2: {
                ret = "PREPARING";
                break;
            }
            case 0: {
                ret = "PREPARED";
                break;
            }
            case 4: {
                ret = "HEURISTIC MIXED";
                break;
            }
            case 3: {
                ret = "HEURISTIC HAZARD";
                break;
            }
            case 1: {
                ret = "HEURISTIC COMMIT";
                break;
            }
            case 2: {
                ret = "HEURISTIC ROLLBACK";
                break;
            }
            case 6: {
                ret = "COMMITTING";
                break;
            }
            case 5: {
                ret = "ROLLING BACK";
                break;
            }
            case 7: {
                ret = "TERMINATED";
                break;
            }
        }
        return ret;
    }

    protected static String[] convertHeuristicMessages(HeuristicMessage[] msgs) {
        String[] ret = new String[msgs.length];
        for (int i = 0; i < msgs.length; ++i) {
            ret[i] = msgs[i] != null ? ((Object)msgs[i]).toString() : "";
        }
        return ret;
    }

    public JmxTransaction(AdminTransaction adminTransaction) {
        this.adminTransaction = adminTransaction;
    }

    protected AdminTransaction getAdminTransaction() {
        return this.adminTransaction;
    }

    protected void unregister() {
        try {
            if (this.server.isRegistered(this.name)) {
                this.server.unregisterMBean(this.name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public String getTid() {
        return this.adminTransaction.getTid();
    }

    @Override
    public String getState() {
        return JmxTransaction.convertState(this.adminTransaction.getState());
    }

    @Override
    public String[] getTags() {
        return JmxTransaction.convertHeuristicMessages(this.adminTransaction.getTags());
    }

    @Override
    public String[] getHeuristicMessages() {
        return JmxTransaction.convertHeuristicMessages(this.adminTransaction.getHeuristicMessages());
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        if (name == null) {
            name = new ObjectName("atomikos.transactions", "TID", this.getTid());
        }
        this.name = name;
        return name;
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

