/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class BaseTransactionManager
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(BaseTransactionManager.class);
    private static final long serialVersionUID = -552994279460833505L;
    private Map<Thread, Stack<CompositeTransaction>> threadtotxmap_ = new HashMap<Thread, Stack<CompositeTransaction>>();
    private Map<CompositeTransaction, Thread> txtothreadmap_ = new HashMap<CompositeTransaction, Thread>();
    private TransactionServiceImp service_;
    private boolean initialized_ = false;

    protected BaseTransactionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction ct) {
        Thread thread = null;
        Map<CompositeTransaction, Thread> map = this.txtothreadmap_;
        synchronized (map) {
            thread = this.txtothreadmap_.get(ct);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack removeThreadMappings(Thread thread) {
        Stack<CompositeTransaction> ret = null;
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            ret = this.threadtotxmap_.remove(thread);
            CompositeTransaction tx = ret.peek();
            this.txtothreadmap_.remove(tx);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction ct, Thread thread) throws IllegalStateException, SysException {
        ct.addSubTxAwareParticipant(this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            if (TxState.ACTIVE.equals(ct.getState())) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
                if (txs == null) {
                    txs = new Stack();
                }
                txs.push(ct);
                this.threadtotxmap_.put(thread, txs);
                this.txtothreadmap_.put(ct, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack stack, Thread thread) throws IllegalStateException {
        CompositeTransaction tx = (CompositeTransaction)stack.peek();
        tx.addSubTxAwareParticipant(this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            TxState state = tx.getState();
            if (TxState.ACTIVE.equals(state) || TxState.MARKED_ABORT.equals(state)) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
                if (txs != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(tx, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransactionImp getCurrentTx() {
        Thread thread = Thread.currentThread();
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
            if (txs == null) {
                return null;
            }
            return (CompositeTransactionImp)txs.peek();
        }
    }

    public void init(TransactionServiceImp service, Properties properties) throws SysException {
        this.service_ = service;
        this.service_.init(properties);
        this.initialized_ = true;
    }

    public Participant getParticipant(String root) {
        return this.service_.getParticipant(root);
    }

    @Override
    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public CompositeTransaction getCompositeTransaction() throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("getCompositeTransaction()  returning instance with id " + ct.getTid());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("getCompositeTransaction() returning NULL!");
        }
        return ct;
    }

    @Override
    public CompositeTransaction getCompositeTransaction(String tid) throws SysException {
        CompositeTransaction ret = this.service_.getCompositeTransaction(tid);
        if (ret != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("getCompositeTransaction ( " + tid + " ) returning instance with tid " + ret.getTid());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("getCompositeTransaction ( " + tid + " ) returning null");
        }
        return ret;
    }

    protected synchronized CompositeTransaction recreateCompositeTransaction(Propagation context, boolean orphancheck, boolean heur_commit) throws SysException {
        CompositeTransaction ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            LOGGER.logWarning("Recreating a transaction with existing transaction: " + ct.getTid());
        }
        ct = this.service_.recreateCompositeTransaction(context, orphancheck, heur_commit);
        Thread t = Thread.currentThread();
        this.setThreadMappings(ct, t);
        return ct;
    }

    @Override
    public CompositeTransaction suspend() throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp ret = this.getCurrentTx();
        if (ret != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("suspend() for transaction " + ret.getTid());
            }
            Thread thread = Thread.currentThread();
            this.removeThreadMappings(thread);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("suspend() called without a transaction context");
        }
        return ret;
    }

    @Override
    public void resume(CompositeTransaction ct) throws IllegalStateException, SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        Stack ancestors = new Stack();
        Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
        Stack lineage = (Stack)ct.getLineage().clone();
        boolean done = false;
        while (!lineage.isEmpty() && !done) {
            CompositeTransaction parent = (CompositeTransaction)lineage.pop();
            if (!parent.isLocal()) {
                done = true;
                continue;
            }
            tmp.push(parent);
        }
        while (!tmp.isEmpty()) {
            ancestors.push(tmp.pop());
        }
        ancestors.push(ct);
        Thread thread = Thread.currentThread();
        this.restoreThreadMappings(ancestors, thread);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("resume ( " + ct + " ) done for transaction " + ct.getTid());
        }
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.service_.shutdown(force);
    }

    protected void startlistening(CompositeTransaction transaction) throws SysException {
        transaction.addSubTxAwareParticipant(this);
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        Thread thread = this.getThread(ct);
        if (thread == null) {
            return;
        }
        Stack mappings = this.removeThreadMappings(thread);
        if (mappings != null && !mappings.empty()) {
            mappings.pop();
            if (!mappings.empty()) {
                this.restoreThreadMappings(mappings, thread);
            }
        }
    }

    @Override
    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        Stack errors = new Stack();
        CompositeTransactionImp ct = null;
        CompositeTransaction ret = null;
        ct = this.getCurrentTx();
        if (ct == null) {
            ret = this.service_.createCompositeTransaction(timeout);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("createCompositeTransaction ( " + timeout + " ): " + "created new ROOT transaction with id " + ret.getTid());
            }
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("createCompositeTransaction ( " + timeout + " )");
            }
            ret = ct.getTransactionControl().createSubTransaction();
        }
        Thread thread = Thread.currentThread();
        this.setThreadMappings(ret, thread);
        return ret;
    }
}

