/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CommitCallback;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.RollbackCallback;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class IndoubtStateHandler
extends CoordinatorStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(IndoubtStateHandler.class);
    private static final long serialVersionUID = 7541858185410144702L;
    private int inquiries_;
    private boolean recovered_;

    public IndoubtStateHandler() {
    }

    IndoubtStateHandler(CoordinatorImp coordinator) {
        super(coordinator);
        this.inquiries_ = 0;
        this.recovered_ = false;
    }

    IndoubtStateHandler(CoordinatorStateHandler previous) {
        super(previous);
        this.inquiries_ = 0;
        this.recovered_ = false;
    }

    @Override
    protected void recover(CoordinatorImp coordinator) {
        super.recover(coordinator);
        if (this.getCoordinator().getState().equals(TxState.COMMITTING)) {
            Enumeration<Participant> enumm = this.getCoordinator().getParticipants().elements();
            Hashtable<Participant, TxState> hazards = new Hashtable<Participant, TxState>();
            while (enumm.hasMoreElements()) {
                Participant p = enumm.nextElement();
                if (this.getReadOnlyTable().containsKey(p)) continue;
                this.addToHeuristicMap(p, TxState.HEUR_HAZARD);
                hazards.put(p, TxState.HEUR_HAZARD);
            }
            HeurHazardStateHandler hazardStateHandler = new HeurHazardStateHandler((CoordinatorStateHandler)this, hazards);
            this.getCoordinator().setStateHandler(hazardStateHandler);
            hazardStateHandler.recover(coordinator);
        }
        this.recovered_ = true;
    }

    @Override
    protected TxState getState() {
        return TxState.IN_DOUBT;
    }

    @Override
    protected void onTimeout() {
        if (!this.getCoordinator().getState().equals(this.getState())) {
            return;
        }
        try {
            if ((long)this.inquiries_ < this.getCoordinator().getMaxIndoubtTicks()) {
                ++this.inquiries_;
                if ((long)this.inquiries_ >= this.getCoordinator().getMaxIndoubtTicks() / 2L && this.getCoordinator().getSuperiorRecoveryCoordinator() != null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.logInfo("Requesting replayCompletion on behalf of coordinator " + this.getCoordinator().getCoordinatorId());
                    }
                    this.getCoordinator().getSuperiorRecoveryCoordinator().replayCompletion(this.getCoordinator());
                }
            } else if (this.getCoordinator().getSuperiorRecoveryCoordinator() == null) {
                this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                    @Override
                    public HeuristicMessage[] doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                        return IndoubtStateHandler.this.rollbackFromWithinCallback(true, !IndoubtStateHandler.this.recovered_);
                    }
                });
            } else if (this.getCoordinator().prefersHeuristicCommit()) {
                this.commitWithAfterCompletionNotification(new CommitCallback(){

                    @Override
                    public HeuristicMessage[] doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                        return IndoubtStateHandler.this.commitFromWithinCallback(true, false);
                    }
                });
            } else {
                this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                    @Override
                    public HeuristicMessage[] doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                        return IndoubtStateHandler.this.rollbackFromWithinCallback(true, true);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in timeout of INDOUBT state: " + e.getMessage());
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count) {
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        return 1;
    }

    @Override
    protected HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        return this.commitWithAfterCompletionNotification(new CommitCallback(){

            @Override
            public HeuristicMessage[] doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                return IndoubtStateHandler.this.commitFromWithinCallback(false, false);
            }
        });
    }

    @Override
    protected HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        return this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

            @Override
            public HeuristicMessage[] doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                return IndoubtStateHandler.this.rollbackFromWithinCallback(true, false);
            }
        });
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.inquiries_);
        out.writeBoolean(this.recovered_);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.inquiries_ = in.readInt();
        this.recovered_ = in.readBoolean();
    }
}

