/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.imp.CompositeTransactionAdaptor;
import java.util.Stack;

public class PropagationImp
implements Propagation {
    private Stack lineage_;
    private boolean serial_;
    private long timeout_;

    public static Propagation adaptPropagation(Propagation propagation, RecoveryCoordinator adaptor) {
        Stack lineage = propagation.getLineage();
        CompositeTransaction remote = (CompositeTransaction)lineage.peek();
        CompositeTransactionAdaptor ct = new CompositeTransactionAdaptor(lineage, remote.getTid(), remote.isSerial(), adaptor, remote.getCompositeCoordinator().isRecoverableWhileActive());
        lineage.pop();
        lineage.push(ct);
        return new PropagationImp(lineage, propagation.isSerial(), propagation.getTimeOut());
    }

    public PropagationImp(Stack lineage, boolean serial, long timeout) {
        this.serial_ = serial;
        this.lineage_ = (Stack)lineage.clone();
        this.timeout_ = timeout;
    }

    @Override
    public Stack getLineage() {
        return this.lineage_;
    }

    @Override
    public boolean isSerial() {
        return this.serial_;
    }

    @Override
    public long getTimeOut() {
        return this.timeout_;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof PropagationImp) {
            PropagationImp other = (PropagationImp)o;
            CompositeTransaction otherCt = (CompositeTransaction)other.lineage_.peek();
            CompositeTransaction ct = (CompositeTransaction)this.lineage_.peek();
            ret = ct.isSameTransaction(otherCt);
        }
        return ret;
    }

    public int hashCode() {
        int ret = 0;
        CompositeTransaction ct = (CompositeTransaction)this.lineage_.peek();
        ret = ct.getTid().hashCode();
        return ret;
    }
}

