/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.DataSerializable;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Dictionary;

public class RollbackOnlyParticipant
implements Participant,
DataSerializable {
    private static final Logger LOG = LoggerFactory.createLogger(RollbackOnlyParticipant.class);
    private StringHeuristicMessage msg_;

    RollbackOnlyParticipant(StringHeuristicMessage msg) {
        this.msg_ = msg;
    }

    @Override
    public boolean recover() throws SysException {
        return false;
    }

    @Override
    public void setCascadeList(Dictionary allParticipants) throws SysException {
    }

    @Override
    public void setGlobalSiblingCount(int count) {
    }

    @Override
    public String getURI() {
        return null;
    }

    @Override
    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        throw new RollbackException(this.msg_.toString());
    }

    @Override
    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (onePhase) {
            throw new RollbackException(this.msg_.toString());
        }
        LOG.logWarning("Unexpected 2-phase commit: outcome should be rollback!");
        return this.getHeuristicMessages();
    }

    @Override
    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        return this.getHeuristicMessages();
    }

    @Override
    public void forget() {
    }

    @Override
    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] ret = new HeuristicMessage[]{this.msg_};
        return ret;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.msg_.toString());
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.msg_ = new StringHeuristicMessage(in.readUTF());
    }
}

