/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.TransitionTable;
import com.atomikos.icatch.TxState;
import java.util.Hashtable;

class TransactionTransitionTable
implements TransitionTable<TxState> {
    protected Hashtable transitions;
    protected static Hashtable<TxState, Hashtable<TxState, Object>> defaultTransitions;

    protected static Hashtable<TxState, Hashtable<TxState, Object>> defaultTransitions() {
        if (defaultTransitions == null) {
            Hashtable defaultTrans = new Hashtable();
            Hashtable<TxState, Object> fromActive = new Hashtable<TxState, Object>();
            fromActive.put(TxState.ACTIVE, new Object());
            fromActive.put(TxState.ABORTING, new Object());
            fromActive.put(TxState.COMMITTING, new Object());
            fromActive.put(TxState.PREPARING, new Object());
            defaultTrans.put(TxState.ACTIVE, fromActive);
            Hashtable<TxState, Object> fromABORTING = new Hashtable<TxState, Object>();
            fromABORTING.put(TxState.TERMINATED, new Object());
            fromABORTING.put(TxState.ABORTING, new Object());
            fromABORTING.put(TxState.HEUR_ABORTED, new Object());
            fromABORTING.put(TxState.HEUR_COMMITTED, new Object());
            fromABORTING.put(TxState.HEUR_MIXED, new Object());
            fromABORTING.put(TxState.HEUR_HAZARD, new Object());
            defaultTrans.put(TxState.ABORTING, fromABORTING);
            Hashtable<TxState, Object> fromPREPARING = new Hashtable<TxState, Object>();
            fromPREPARING.put(TxState.IN_DOUBT, new Object());
            fromPREPARING.put(TxState.TERMINATED, new Object());
            fromPREPARING.put(TxState.ABORTING, new Object());
            fromPREPARING.put(TxState.COMMITTING, new Object());
            defaultTrans.put(TxState.PREPARING, fromPREPARING);
            Hashtable<TxState, Object> fromIN_DOUBT = new Hashtable<TxState, Object>();
            fromIN_DOUBT.put(TxState.COMMITTING, new Object());
            fromIN_DOUBT.put(TxState.ABORTING, new Object());
            defaultTrans.put(TxState.IN_DOUBT, fromIN_DOUBT);
            Hashtable<TxState, Object> fromCOMMING = new Hashtable<TxState, Object>();
            fromCOMMING.put(TxState.TERMINATED, new Object());
            fromCOMMING.put(TxState.HEUR_COMMITTED, new Object());
            fromCOMMING.put(TxState.HEUR_ABORTED, new Object());
            fromCOMMING.put(TxState.HEUR_MIXED, new Object());
            fromCOMMING.put(TxState.HEUR_HAZARD, new Object());
            defaultTrans.put(TxState.COMMITTING, fromCOMMING);
            Hashtable<TxState, Object> fromHEURCOMM = new Hashtable<TxState, Object>();
            fromHEURCOMM.put(TxState.TERMINATED, new Object());
            defaultTrans.put(TxState.HEUR_COMMITTED, fromHEURCOMM);
            Hashtable<TxState, Object> fromHEURMIXED = new Hashtable<TxState, Object>();
            fromHEURMIXED.put(TxState.HEUR_MIXED, new Object());
            fromHEURMIXED.put(TxState.TERMINATED, new Object());
            defaultTrans.put(TxState.HEUR_MIXED, fromHEURMIXED);
            Hashtable<TxState, Object> fromHEURHAZARD = new Hashtable<TxState, Object>();
            fromHEURHAZARD.put(TxState.HEUR_HAZARD, new Object());
            fromHEURHAZARD.put(TxState.TERMINATED, new Object());
            defaultTrans.put(TxState.HEUR_HAZARD, fromHEURHAZARD);
            Hashtable<TxState, Object> fromHEURABORTED = new Hashtable<TxState, Object>();
            fromHEURABORTED.put(TxState.TERMINATED, new Object());
            fromHEURABORTED.put(TxState.HEUR_ABORTED, new Object());
            defaultTrans.put(TxState.HEUR_ABORTED, fromHEURABORTED);
            Hashtable<TxState, Object> fromTERMINATED = new Hashtable<TxState, Object>();
            fromTERMINATED.put(TxState.TERMINATED, new Object());
            defaultTrans.put(TxState.TERMINATED, fromTERMINATED);
            defaultTransitions = defaultTrans;
        }
        return defaultTransitions;
    }

    public TransactionTransitionTable() {
        this.transitions = TransactionTransitionTable.defaultTransitions();
    }

    public TransactionTransitionTable(Hashtable edges) {
        this.transitions = edges;
    }

    public void setTransitions(Hashtable edges) {
        this.transitions = edges;
    }

    @Override
    public boolean legalTransition(TxState from, TxState to) {
        if (this.transitions == null) {
            return false;
        }
        if (!this.transitions.containsKey(from)) {
            return false;
        }
        Object allowedNextStates = this.transitions.get(from);
        if (!(allowedNextStates instanceof Hashtable)) {
            return false;
        }
        Hashtable toStates = (Hashtable)allowedNextStates;
        return toStates.containsKey(to);
    }
}

