/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.TemporaryXATransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.Sync2Sync;
import com.atomikos.icatch.jta.XAResourceKey;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

class TransactionImp
implements Transaction {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionImp.class);
    private CompositeTransaction ct_;
    private Map<XAResourceKey, XAResourceTransaction> xaResourceToResourceTransactionMap_;
    private boolean autoRegistration_;

    static void rethrowAsJtaRollbackException(String msg, Throwable cause) throws javax.transaction.RollbackException {
        javax.transaction.RollbackException ret = new javax.transaction.RollbackException(msg);
        ret.initCause(cause);
        throw ret;
    }

    static void rethrowAsJtaHeuristicMixedException(String msg, Throwable cause) throws HeuristicMixedException {
        HeuristicMixedException ret = new HeuristicMixedException(msg);
        ret.initCause(cause);
        throw ret;
    }

    static void rethrowAsJtaHeuristicRollbackException(String msg, Throwable cause) throws HeuristicRollbackException {
        HeuristicRollbackException ret = new HeuristicRollbackException(msg);
        ret.initCause(cause);
        throw ret;
    }

    TransactionImp(CompositeTransaction ct, boolean autoRegistration) {
        this.ct_ = ct;
        this.autoRegistration_ = autoRegistration;
        this.xaResourceToResourceTransactionMap_ = new HashMap<XAResourceKey, XAResourceTransaction>();
    }

    CompositeTransaction getCT() {
        return this.ct_;
    }

    private synchronized void addXAResourceTransaction(XAResourceTransaction restx, XAResource xares) {
        this.xaResourceToResourceTransactionMap_.put(new XAResourceKey(xares), restx);
    }

    private void assertActiveOrSuspended(XAResourceTransaction restx) {
        if (!restx.isActive() && !restx.isXaSuspended()) {
            LOGGER.logWarning("Unexpected resource transaction state for " + restx);
        }
    }

    private synchronized XAResourceTransaction findXAResourceTransaction(XAResource xares) {
        XAResourceTransaction ret = null;
        ret = this.xaResourceToResourceTransactionMap_.get(new XAResourceKey(xares));
        if (ret != null) {
            this.assertActiveOrSuspended(ret);
        }
        return ret;
    }

    private synchronized void removeXAResourceTransaction(XAResource xares) {
        this.xaResourceToResourceTransactionMap_.remove(new XAResourceKey(xares));
    }

    public void registerSynchronization(Synchronization s) throws IllegalStateException, SystemException {
        try {
            Sync2Sync adaptor = new Sync2Sync(s);
            this.ct_.registerSynchronization(adaptor);
        }
        catch (SysException se) {
            String msg = "Unexpected error during registerSynchronization";
            LOGGER.logWarning(msg, se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
    }

    public int getStatus() {
        TxState state = this.ct_.getState();
        if (state.equals(TxState.IN_DOUBT)) {
            return 2;
        }
        if (state.equals(TxState.PREPARING)) {
            return 7;
        }
        if (state.equals(TxState.ACTIVE)) {
            return 0;
        }
        if (state.equals(TxState.MARKED_ABORT)) {
            return 1;
        }
        if (state.equals(TxState.COMMITTING)) {
            return 8;
        }
        if (state.equals(TxState.ABORTING)) {
            return 9;
        }
        if (state.equals(TxState.COMMITTED)) {
            return 3;
        }
        if (state.equals(TxState.ABORTED)) {
            return 4;
        }
        return 5;
    }

    public void commit() throws javax.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, SecurityException {
        try {
            this.ct_.commit();
        }
        catch (HeurHazardException hh) {
            TransactionImp.rethrowAsJtaHeuristicMixedException(hh.getMessage(), hh);
        }
        catch (HeurRollbackException hr) {
            TransactionImp.rethrowAsJtaHeuristicRollbackException(hr.getMessage(), hr);
        }
        catch (HeurMixedException hm) {
            TransactionImp.rethrowAsJtaHeuristicMixedException(hm.getMessage(), hm);
        }
        catch (SysException se) {
            LOGGER.logWarning(se.getMessage(), se);
            throw new ExtendedSystemException(se.getMessage(), se.getErrors());
        }
        catch (RollbackException rb) {
            String msg = rb.getMessage();
            Throwable cause = rb.getCause();
            if (cause == null) {
                cause = rb;
            }
            TransactionImp.rethrowAsJtaRollbackException(msg, cause);
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.ct_.rollback();
        }
        catch (SysException se) {
            LOGGER.logWarning(se.getMessage(), se);
            throw new ExtendedSystemException(se.getMessage(), se.getErrors());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.ct_.setRollbackOnly();
    }

    public boolean enlistResource(XAResource xares) throws javax.transaction.RollbackException, SystemException, IllegalStateException {
        TransactionalResource res = null;
        XAResourceTransaction restx = null;
        Stack<Exception> errors = new Stack<Exception>();
        int status = this.getStatus();
        switch (status) {
            case 1: 
            case 4: 
            case 9: {
                String msg = "Transaction rollback - enlisting more resources is useless.";
                LOGGER.logWarning(msg);
                throw new javax.transaction.RollbackException(msg);
            }
            case 2: 
            case 3: 
            case 5: {
                String msg = "Enlisting more resources is no longer permitted: transaction is in state " + this.ct_.getState();
                LOGGER.logWarning(msg);
                throw new IllegalStateException(msg);
            }
        }
        XAResourceTransaction suspendedXAResourceTransaction = this.findXAResourceTransaction(xares);
        if (suspendedXAResourceTransaction != null) {
            if (!suspendedXAResourceTransaction.isXaSuspended()) {
                String msg = "The given XAResource instance is being enlisted a second time without delist in between?";
                LOGGER.logWarning(msg);
                throw new IllegalStateException(msg);
            }
            try {
                suspendedXAResourceTransaction.setXAResource(xares);
                suspendedXAResourceTransaction.xaResume();
            }
            catch (XAException xaerr) {
                if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                    TransactionImp.rethrowAsJtaRollbackException("Transaction was already rolled back inside the back-end resource. Further enlists are useless.", xaerr);
                }
                errors.push(xaerr);
                throw new ExtendedSystemException("Unexpected error during enlist", errors);
            }
        }
        res = this.findRecoverableResourceForXaResource(xares);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("enlistResource ( " + xares + " ) with transaction " + this.toString());
        }
        if (res == null) {
            String msg = "There is no registered resource that can recover the given XAResource instance. \nEither enable automatic resource registration, or register a corresponding resource.";
            LOGGER.logWarning(msg);
            throw new SystemException(msg);
        }
        try {
            restx = (XAResourceTransaction)res.getResourceTransaction(this.ct_);
            restx.setXAResource(xares);
            restx.resume();
        }
        catch (ResourceException re) {
            Stack<Exception> nested = re.getErrors();
            if (!nested.empty() && nested.peek() instanceof XAException) {
                XAException xaerr = (XAException)nested.peek();
                if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                    TransactionImp.rethrowAsJtaRollbackException("The transaction was rolled back in the back-end resource. Further enlists are useless.", re);
                }
            }
            errors.push(re);
            throw new ExtendedSystemException("Unexpected error during enlist", errors);
        }
        catch (RuntimeException e) {
            throw e;
        }
        this.addXAResourceTransaction(restx, xares);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransactionalResource findRecoverableResourceForXaResource(XAResource xares) {
        XATransactionalResource ret = null;
        Enumeration enumm = Configuration.getResources();
        while (enumm.hasMoreElements()) {
            XATransactionalResource xatxres;
            RecoverableResource rres = (RecoverableResource)enumm.nextElement();
            if (!(rres instanceof XATransactionalResource) || !(xatxres = (XATransactionalResource)rres).usesXAResource(xares)) continue;
            ret = xatxres;
        }
        if (ret != null || !this.autoRegistration_) return ret;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            ret = new TemporaryXATransactionalResource(xares);
            if (Configuration.getResource(ret.getName()) != null) return ret;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("constructing new temporary resource for unknown XAResource: " + xares);
            }
            Configuration.addResource(ret);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ret;
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        XAResourceTransaction active;
        Stack<Exception> errors = new Stack<Exception>();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("delistResource ( " + xares + " ) with transaction " + this.toString());
        }
        if ((active = this.findXAResourceTransaction(xares)) == null) {
            String msg = "Illegal attempt to delist an XAResource instance that was not previously enlisted.";
            LOGGER.logWarning(msg);
            throw new IllegalStateException(msg);
        }
        if (flag == 0x4000000 || flag == 0x20000000) {
            try {
                active.suspend();
            }
            catch (ResourceException re) {
                errors.push(re);
                throw new ExtendedSystemException("Error in delisting the given XAResource", errors);
            }
            this.removeXAResourceTransaction(xares);
            if (flag == 0x20000000) {
                this.setRollbackOnly();
            }
        } else if (flag == 0x2000000) {
            try {
                active.xaSuspend();
            }
            catch (XAException xaerr) {
                errors.push(xaerr);
                throw new ExtendedSystemException("Error in delisting the given XAResource", errors);
            }
        } else {
            String msg = "Unknown delist flag: " + flag;
            LOGGER.logWarning(msg);
            throw new SystemException(msg);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TransactionImp)) {
            return false;
        }
        TransactionImp other = (TransactionImp)o;
        return this.ct_.isSameTransaction(other.ct_);
    }

    public int hashCode() {
        return this.ct_.hashCode();
    }

    public String toString() {
        return this.ct_.getTid().toString();
    }

    void suspendEnlistedXaResources() throws ExtendedSystemException {
        for (XAResourceTransaction resTx : this.xaResourceToResourceTransactionMap_.values()) {
            try {
                resTx.xaSuspend();
            }
            catch (XAException e) {
                Stack<XAException> errors = new Stack<XAException>();
                errors.push(e);
                throw new ExtendedSystemException("Error in suspending the given XAResource", errors);
            }
        }
    }

    void resumeEnlistedXaReources() throws ExtendedSystemException {
        Iterator<XAResourceTransaction> xaResourceTransactions = this.xaResourceToResourceTransactionMap_.values().iterator();
        while (xaResourceTransactions.hasNext()) {
            XAResourceTransaction resTx = xaResourceTransactions.next();
            try {
                resTx.xaResume();
                xaResourceTransactions.remove();
            }
            catch (XAException e) {
                Stack<XAException> errors = new Stack<XAException>();
                errors.push(e);
                throw new ExtendedSystemException("Error in resuming the given XAResource", errors);
            }
        }
    }
}

