/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.jdbc.AtomikosXAPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

class AtomikosXAConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosXAConnectionFactory.class);
    private JdbcTransactionalResource jdbcTransactionalResource;
    private XADataSource xaDataSource;
    private ConnectionPoolProperties props;

    public AtomikosXAConnectionFactory(XADataSource xaDataSource, JdbcTransactionalResource jdbcTransactionalResource, ConnectionPoolProperties props) {
        this.xaDataSource = xaDataSource;
        this.jdbcTransactionalResource = jdbcTransactionalResource;
        this.props = props;
    }

    @Override
    public XPooledConnection createPooledConnection() throws CreateConnectionException {
        try {
            XAConnection xaConnection = this.xaDataSource.getXAConnection();
            return new AtomikosXAPooledConnection(xaConnection, this.jdbcTransactionalResource, this.props);
        }
        catch (SQLException e) {
            String msg = "XAConnectionFactory: failed to create pooled connection - DBMS down or unreachable?";
            LOGGER.logWarning(msg, e);
            throw new CreateConnectionException(msg, e);
        }
    }
}

