/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.nonxa.AtomikosNonXAPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

class AtomikosNonXAConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAConnectionFactory.class);
    private String url;
    private String driverClassName;
    private String user;
    private String password;
    private ConnectionPoolProperties props;
    private int loginTimeout;
    private boolean readOnly;
    private Driver driver;
    protected Properties connectionProperties = new Properties();

    public AtomikosNonXAConnectionFactory(ConnectionPoolProperties props, String url, String driverClassName, String user, String password, int loginTimeout, boolean readOnly) {
        this.props = props;
        this.user = user;
        this.password = password;
        this.url = url;
        this.driverClassName = driverClassName;
        this.loginTimeout = loginTimeout;
        this.readOnly = readOnly;
    }

    public void init() throws SQLException {
        try {
            Class driverClass = ClassLoadingHelper.loadClass(this.driverClassName);
            Object aDriver = driverClass.newInstance();
            if (!(aDriver instanceof Driver)) {
                String msg = "Driver class '" + this.driverClassName + "' does not seem to be a valid JDBC driver - please check the spelling and verify your JDBC vendor's documentation";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            }
            this.driver = (Driver)aDriver;
            if (this.user != null) {
                this.connectionProperties.put("user", this.user);
            }
            if (this.password != null) {
                this.connectionProperties.put("password", this.password);
            }
        }
        catch (InstantiationException e) {
            AtomikosSQLException.throwAtomikosSQLException("Could not instantiate driver class: " + this.driverClassName);
        }
        catch (IllegalAccessException e) {
            AtomikosSQLException.throwAtomikosSQLException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            AtomikosSQLException.throwAtomikosSQLException("Driver class not found: '" + this.driverClassName + "' - please make sure the spelling is correct.");
        }
        DriverManager.setLoginTimeout(this.loginTimeout);
    }

    private Connection getConnection() throws SQLException {
        Connection ret = null;
        ret = this.driver.connect(this.url, this.connectionProperties);
        return ret;
    }

    @Override
    public XPooledConnection createPooledConnection() throws CreateConnectionException {
        Connection c;
        try {
            c = this.getConnection();
        }
        catch (SQLException e) {
            LOGGER.logWarning("NonXAConnectionFactory: failed to create connection: ", e);
            throw new CreateConnectionException("Could not create JDBC connection", e);
        }
        return new AtomikosNonXAPooledConnection(c, this.props, this.readOnly);
    }
}

