/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.util.ClassLoadingHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource,
Serializable {
    private String driverClassName;
    private String url;
    private String user;
    private String password;

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String user, String pw) throws SQLException {
        Connection ret = null;
        try {
            ClassLoadingHelper.loadClass(this.getDriverClassName()).newInstance();
        }
        catch (InstantiationException e) {
            AtomikosSQLException.throwAtomikosSQLException("Could not instantiate driver class: " + this.getDriverClassName());
        }
        catch (IllegalAccessException e) {
            AtomikosSQLException.throwAtomikosSQLException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            AtomikosSQLException.throwAtomikosSQLException("Driver class not found: " + this.getDriverClassName());
        }
        ret = DriverManager.getConnection(this.getUrl(), user, pw);
        return ret;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        DriverManager.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int secs) throws SQLException {
        DriverManager.setLoginTimeout(secs);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    private String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException();
    }
}

