/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.imp.AbstractLogStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Vector;

public class FileLogStream
extends AbstractLogStream
implements LogStream {
    private static final Logger LOGGER = LoggerFactory.createLogger(FileLogStream.class);
    private ObjectOutputStream ooutput_;
    private boolean corrupt_;

    public FileLogStream(String baseDir, String baseName) throws IOException {
        super(baseDir, baseName);
    }

    void markAsCorrupt() {
        this.corrupt_ = true;
    }

    @Override
    public synchronized Vector<Recoverable> recover() throws LogException {
        if (this.corrupt_) {
            throw new LogException("Instance might be corrupted");
        }
        Vector<Recoverable> ret = new Vector<Recoverable>();
        FileInputStream in = null;
        try {
            FileInputStream f;
            in = f = this.file_.openLastValidVersionForReading();
            ObjectInputStream ins = new ObjectInputStream(in);
            int count = 0;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("Starting read of logfile " + this.file_.getCurrentVersionFileName());
            }
            while (((InputStream)in).available() > 0) {
                Recoverable nxt = (Recoverable)ins.readObject();
                ret.addElement(nxt);
                if (++count % 10 != 0) continue;
                LOGGER.logInfo(".");
            }
            LOGGER.logInfo("Done read of logfile");
        }
        catch (EOFException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", unexpectedEOF);
        }
        catch (StreamCorruptedException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", unexpectedEOF);
        }
        catch (ObjectStreamException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", unexpectedEOF);
        }
        catch (FileNotFoundException firstStart) {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                throw new LogException("Error in recover", io);
            }
        }
        catch (Exception e) {
            String msg = "Error in recover";
            LOGGER.logWarning(msg, e);
            throw new LogException(msg, e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException io) {
                throw new LogException("Error in recover", io);
            }
        }
        return ret;
    }

    @Override
    public synchronized void writeCheckpoint(Enumeration elements) throws LogException {
        this.closeOutput();
        try {
            this.output_ = this.file_.openNewVersionForWriting();
            this.ooutput_ = new ObjectOutputStream(new BufferedOutputStream(this.output_, 4096));
            while (elements != null && elements.hasMoreElements()) {
                Object next = elements.nextElement();
                this.ooutput_.writeObject(next);
            }
            this.ooutput_.flush();
            this.output_.flush();
            this.output_.getFD().sync();
            if (this.corrupt_) {
                throw new LogException("Instance corrupted");
            }
            try {
                this.file_.discardBackupVersion();
            }
            catch (IOException errorOnDelete) {
                this.markAsCorrupt();
                throw new LogException("Old file could not be deleted");
            }
        }
        catch (Exception e) {
            throw new LogException("Error during checkpointing", e);
        }
    }

    @Override
    public synchronized void flushObject(Object o, boolean shouldSync) throws LogException {
        if (this.ooutput_ == null) {
            throw new LogException("Not Initialized or already closed");
        }
        try {
            this.ooutput_.writeObject(o);
            this.output_.flush();
            this.ooutput_.flush();
            if (shouldSync) {
                this.output_.getFD().sync();
            }
        }
        catch (IOException e) {
            throw new LogException(e.getMessage(), e);
        }
    }
}

