/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.icatch.TxState;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.Utils;
import com.atomikos.persistence.imp.AbstractLogStream;
import com.atomikos.persistence.imp.AbstractObjectLog;
import com.atomikos.persistence.imp.FileLogStream;
import com.atomikos.persistence.imp.StateObjectImage;
import com.atomikos.persistence.imp.StreamObjectLog;
import com.atomikos.util.ClassLoadingHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMPreEnterListener<TxState> {
    private static final String WRITE_AHEAD_OBJECT_LOG_CLASSNAME = "com.atomikos.persistence.imp.WriteAheadObjectLog";
    private static final Logger LOGGER = LoggerFactory.createLogger(StateRecoveryManagerImp.class);
    private ObjectLog objectlog_;

    @Override
    public void register(StateRecoverable<TxState> staterecoverable) {
        if (staterecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        TxState[] states = staterecoverable.getRecoverableStates();
        if (states != null) {
            int i;
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
            states = staterecoverable.getFinalStates();
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
        }
    }

    @Override
    public void preEnter(FSMEnterEvent<TxState> event) throws IllegalStateException {
        TxState state = event.getState();
        StateRecoverable source = (StateRecoverable)event.getSource();
        ObjectImage img = source.getObjectImage(state);
        if (img != null) {
            StateObjectImage simg = new StateObjectImage(img);
            T[] finalstates = source.getFinalStates();
            boolean delete = false;
            for (int i = 0; i < finalstates.length; ++i) {
                if (!state.equals(finalstates[i])) continue;
                delete = true;
            }
            try {
                if (!delete) {
                    this.objectlog_.flush(simg);
                } else {
                    this.objectlog_.delete(simg.getId());
                }
            }
            catch (LogException le) {
                le.printStackTrace();
                throw new IllegalStateException("could not flush state image " + le.getMessage() + " " + le.getClass().getName());
            }
        }
    }

    @Override
    public void close() throws LogException {
        this.objectlog_.close();
    }

    @Override
    public StateRecoverable<TxState> recover(Object id) throws LogException {
        StateRecoverable srec = (StateRecoverable)this.objectlog_.recover(id);
        if (srec != null) {
            this.register(srec);
        }
        return srec;
    }

    @Override
    public Vector<StateRecoverable<TxState>> recover() throws LogException {
        Vector<StateRecoverable<TxState>> ret = this.objectlog_.recover();
        Enumeration<StateRecoverable<TxState>> enumm = ret.elements();
        while (enumm.hasMoreElements()) {
            StateRecoverable<TxState> srec = enumm.nextElement();
            this.register(srec);
        }
        return ret;
    }

    @Override
    public void delete(Object id) throws LogException {
        this.objectlog_.delete(id);
    }

    @Override
    public void init(Properties p) throws LogException {
        long chckpt = Long.valueOf(Utils.getTrimmedProperty("com.atomikos.icatch.checkpoint_interval", p));
        String logdir = Utils.getTrimmedProperty("com.atomikos.icatch.log_base_dir", p);
        String logname = Utils.getTrimmedProperty("com.atomikos.icatch.log_base_name", p);
        logdir = Utils.findOrCreateFolder(logdir);
        boolean serializableLogging = "true".equals(Utils.getTrimmedProperty("com.atomikos.icatch.serializable_logging", p));
        AbstractLogStream logstream = null;
        try {
            logstream = serializableLogging ? new FileLogStream(logdir, logname) : new com.atomikos.persistence.dataserializable.FileLogStream(logdir, logname);
            this.objectlog_ = new StreamObjectLog((LogStream)((Object)logstream), chckpt);
            try {
                ObjectLog objectLog;
                this.objectlog_ = objectLog = this.createWriteAheadObjectLogIfAvailableOnClasspath(this.objectlog_);
            }
            catch (Exception writeAheadObjectLogInstantiationFailed) {
                LOGGER.logInfo("com.atomikos.persistence.imp.WriteAheadObjectLog instantiation failed - falling back to default");
            }
            this.objectlog_.init();
        }
        catch (IOException e) {
            throw new LogException(e.getMessage(), e);
        }
    }

    private ObjectLog createWriteAheadObjectLogIfAvailableOnClasspath(ObjectLog normalObjectLog) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class theClass = ClassLoadingHelper.loadClass(WRITE_AHEAD_OBJECT_LOG_CLASSNAME);
        ObjectLog objectLog = (ObjectLog)theClass.newInstance();
        Method delegateMethod = theClass.getMethod("setDelegate", AbstractObjectLog.class);
        delegateMethod.invoke((Object)objectLog, normalObjectLog);
        LOGGER.logInfo("Instantiated write-ahead logging - this constitutes a license violation if you are not a paying customer!");
        return objectLog;
    }
}

