/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.imp.AbstractObjectLog;
import com.atomikos.persistence.imp.SystemLogImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StreamObjectLog
extends AbstractObjectLog
implements ObjectLog {
    private static final Logger LOG = LoggerFactory.createLogger(StreamObjectLog.class);
    private LogStream logstream_;
    private Hashtable<Object, SystemLogImage> contentForNextCheckpoint_;
    private boolean initialized_ = false;
    private long flushesSinceLastCheckpoint_;
    private long maxFlushesBetweenCheckpoints_;

    public StreamObjectLog(LogStream logstream, long maxFlushesBetweenCheckpoints) {
        this.logstream_ = logstream;
        this.contentForNextCheckpoint_ = new Hashtable();
        this.maxFlushesBetweenCheckpoints_ = maxFlushesBetweenCheckpoints;
        this.flushesSinceLastCheckpoint_ = 0L;
    }

    private synchronized void flushAndWriteCheckpointIfThresholdReached(SystemLogImage img, boolean shouldSync) throws LogException {
        this.flushImage(img, shouldSync);
        ++this.flushesSinceLastCheckpoint_;
        if (this.flushesSinceLastCheckpoint_ >= this.maxFlushesBetweenCheckpoints_) {
            this.forceWriteCheckpoint();
        }
    }

    private void flushImage(SystemLogImage img, boolean shouldSync) throws LogException {
        this.logstream_.flushObject(img, shouldSync);
        if (img.isForgettable()) {
            this.discardThisAndPriorImagesForNextCheckpoint(img);
        } else {
            this.rememberImageForNextCheckpoint(img);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() throws LogException {
        if (this.initialized_) {
            return;
        }
        try {
            this.recoverFromUnderlyingLogStream();
        }
        catch (Exception e) {
            this.logAsWarningAndRethrowAsLogException("Unexpected error during init", e, false);
        }
        finally {
            this.initialized_ = true;
            this.forceWriteCheckpoint();
        }
    }

    private void logAsWarningAndRethrowAsLogException(String msg, Exception e, boolean forceCheckpoint) throws LogException {
        LOG.logWarning(msg, e);
        if (forceCheckpoint) {
            this.forceWriteCheckpoint();
        }
        if (e instanceof LogException) {
            throw (LogException)e;
        }
        throw new LogException(msg, e);
    }

    private void recoverFromUnderlyingLogStream() throws LogException {
        Vector<Recoverable> recovered = this.logstream_.recover();
        if (recovered != null) {
            Enumeration<Recoverable> entries = recovered.elements();
            while (entries.hasMoreElements()) {
                SystemLogImage entry = (SystemLogImage)entries.nextElement();
                if (entry.getId() == null) continue;
                if (!entry.isForgettable()) {
                    this.rememberImageForNextCheckpoint(entry);
                    continue;
                }
                this.discardThisAndPriorImagesForNextCheckpoint(entry);
            }
        }
    }

    private void forceWriteCheckpoint() throws LogException {
        this.logstream_.writeCheckpoint(this.contentForNextCheckpoint_.elements());
        this.flushesSinceLastCheckpoint_ = 0L;
    }

    public synchronized Vector recover() throws LogException {
        if (!this.initialized_) {
            throw new LogException("Not initialized");
        }
        Vector<Recoverable> ret = new Vector<Recoverable>();
        Enumeration<SystemLogImage> enumm = this.contentForNextCheckpoint_.elements();
        while (enumm.hasMoreElements()) {
            SystemLogImage next = enumm.nextElement();
            ret.addElement(next.getObjectImage().restore());
        }
        return ret;
    }

    @Override
    public synchronized void flush(Recoverable rec) throws LogException {
        if (rec == null) {
            return;
        }
        SystemLogImage simg = new SystemLogImage(rec, false);
        this.flush(simg, true);
    }

    @Override
    public synchronized void flush(SystemLogImage img, boolean shouldSync) throws LogException {
        if (img == null) {
            return;
        }
        try {
            this.flushAndWriteCheckpointIfThresholdReached(img, shouldSync);
        }
        catch (Exception e) {
            this.logAsWarningAndRethrowAsLogException("Unexpected error during flush", e, true);
        }
    }

    private void rememberImageForNextCheckpoint(SystemLogImage img) {
        this.contentForNextCheckpoint_.put(img.getId(), img);
    }

    private void discardThisAndPriorImagesForNextCheckpoint(SystemLogImage img) {
        if (this.contentForNextCheckpoint_.containsKey(img.getId())) {
            this.contentForNextCheckpoint_.remove(img.getId());
        }
    }

    @Override
    public synchronized Recoverable recover(Object id) throws LogException {
        if (!this.contentForNextCheckpoint_.containsKey(id)) {
            return null;
        }
        SystemLogImage simg = this.contentForNextCheckpoint_.get(id);
        return simg.getObjectImage().restore();
    }

    @Override
    public synchronized void delete(Object id) throws LogException {
        SystemLogImage previous = this.contentForNextCheckpoint_.get(id);
        if (previous == null) {
            return;
        }
        Recoverable bogus = previous.getRecoverable();
        SystemLogImage simg = new SystemLogImage(bogus, true);
        this.flush(simg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws LogException {
        try {
            this.closeUnderlyingLogStream();
        }
        catch (LogException le) {
            this.logAsWarningAndRethrowAsLogException("Unexpected error during close", le, false);
        }
        finally {
            this.initialized_ = false;
        }
    }

    private void closeUnderlyingLogStream() throws LogException {
        if (this.logstream_ != null) {
            this.logstream_.close();
        }
    }
}

