/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.icatch.TxState;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateObjectImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class VolatileStateRecoveryManager
implements StateRecoveryManager,
FSMPreEnterListener<TxState> {
    private Map<Object, StateObjectImage> idToElementMap = new HashMap<Object, StateObjectImage>();

    @Override
    public void register(StateRecoverable<TxState> staterecoverable) {
        if (staterecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        TxState[] states = staterecoverable.getRecoverableStates();
        if (states != null) {
            int i;
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
            states = staterecoverable.getFinalStates();
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
        }
    }

    @Override
    public synchronized void preEnter(FSMEnterEvent<TxState> event) throws IllegalStateException {
        TxState state = event.getState();
        StateRecoverable source = (StateRecoverable)event.getSource();
        ObjectImage img = source.getObjectImage(state);
        if (img != null) {
            StateObjectImage simg = new StateObjectImage(img);
            TxState[] finalstates = (TxState[])source.getFinalStates();
            boolean delete = false;
            for (int i = 0; i < finalstates.length; ++i) {
                if (!state.equals(finalstates[i])) continue;
                delete = true;
            }
            if (!delete) {
                this.idToElementMap.put(simg.getId(), simg);
            } else {
                this.idToElementMap.remove(simg.getId());
            }
        }
    }

    @Override
    public void close() throws LogException {
    }

    @Override
    public StateRecoverable<TxState> recover(Object id) throws LogException {
        StateRecoverable ret = null;
        StateObjectImage simg = this.idToElementMap.get(id);
        if (simg != null) {
            ret = (StateRecoverable)simg.restore();
        }
        return ret;
    }

    @Override
    public Vector<StateRecoverable<TxState>> recover() throws LogException {
        Vector<StateRecoverable<TxState>> ret = new Vector<StateRecoverable<TxState>>();
        for (Object key : this.idToElementMap.keySet()) {
            StateObjectImage simg = this.idToElementMap.get(key);
            ret.add((StateRecoverable)simg.restore());
        }
        return ret;
    }

    @Override
    public synchronized void delete(Object id) throws LogException {
        this.idToElementMap.remove(id);
    }

    @Override
    public void init(Properties properties) throws LogException {
    }
}

