/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.intermediates.NativeLibDependency;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/tasks/FindNativeLibsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "androidJni", "Lorg/gradle/api/artifacts/ArtifactCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "getAndroidJniFiles", "Lorg/gradle/api/file/FileCollection;", "setAndroidJni", "dependency-analysis-gradle-plugin"})
public abstract class FindNativeLibsTask
extends DefaultTask {
    private ArtifactCollection androidJni;

    public final void setAndroidJni(@NotNull ArtifactCollection androidJni) {
        Intrinsics.checkNotNullParameter((Object)androidJni, (String)"androidJni");
        this.androidJni = androidJni;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final FileCollection getAndroidJniFiles() {
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"androidJni.artifactFiles");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        FileTree fileTree = this.getAndroidJniFiles().getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getAndroidJniFiles().asFileTree");
        Set set2 = fileTree.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAndroidJniFiles().asFileTree.files");
        Iterable $this$mapToSet$iv = set2;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            String string = v2.getName();
            collection.add(string);
        }
        Set nativeLibs = (Set)destination$iv$iv;
        ArtifactCollection artifactCollection = this.androidJni;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidJni");
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        destination$iv$iv = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv2 = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            NativeLibDependency nativeLibDependency;
            NativeLibDependency nativeLibDependency2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl3 = false;
            try {
                ResolvedArtifactResult resolvedArtifactResult = it;
                Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactResult, (String)"it");
                nativeLibDependency2 = new NativeLibDependency(GradleStringsKt.toCoordinates(resolvedArtifactResult), nativeLibs);
            }
            catch (GradleException e) {
                nativeLibDependency2 = null;
            }
            if (nativeLibDependency2 == null) continue;
            NativeLibDependency it$iv$iv = nativeLibDependency;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set artifacts = (Set)destination$iv$iv2;
        File $this$bufferWriteJsonSet$iv = outputFile;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl5 = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)NativeLibDependency.class)});
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)artifacts);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public FindNativeLibsTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of all dependencies that supply native libs");
    }
}

