/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.intermediates.ServiceLoaderDependency;
import com.autonomousapps.tasks.FindServiceLoadersTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/tasks/FindServiceLoadersTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compileClasspath", "Lorg/gradle/api/artifacts/ArtifactCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "findServiceLoaders", "", "Lcom/autonomousapps/model/intermediates/ServiceLoaderDependency;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "getCompileClasspath", "Lorg/gradle/api/file/FileCollection;", "setCompileClasspath", "artifacts", "dependency-analysis-gradle-plugin"})
public abstract class FindServiceLoadersTask
extends DefaultTask {
    private ArtifactCollection compileClasspath;

    public final void setCompileClasspath(@NotNull ArtifactCollection artifacts) {
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        this.compileClasspath = artifacts;
    }

    @Classpath
    @NotNull
    public final FileCollection getCompileClasspath() {
        ArtifactCollection artifactCollection = this.compileClasspath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"compileClasspath.artifactFiles");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$flatMapTo$iv$iv$iv;
        void $this$filterTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ArtifactCollection artifactCollection = this.compileClasspath;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        Iterable $this$filter$iv = CollectionsKt.filterNonGradle(artifactCollection);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            File file = it.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMapToSet$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapToSet = false;
        Iterable $this$flatMapToMutableSet$iv$iv = $this$flatMapToSet$iv;
        boolean $i$f$flatMapToMutableSet = false;
        Iterable $i$f$filterTo22 = $this$flatMapToMutableSet$iv$iv;
        Collection destination$iv$iv$iv = new HashSet(CollectionsKt.collectionSizeOrDefault($this$flatMapToMutableSet$iv$iv, 10));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv$iv : $this$flatMapTo$iv$iv$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv$iv = this.findServiceLoaders(it);
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv$iv, (Iterable)list$iv$iv$iv);
        }
        Set serviceLoaders = (Set)destination$iv$iv$iv;
        File $this$bufferWriteJsonSet$iv = outputFile;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)ServiceLoaderDependency.class)});
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)serviceLoaders);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Set<ServiceLoaderDependency> findServiceLoaders(ResolvedArtifactResult artifact) {
        ZipFile zip = new ZipFile(artifact.getFile());
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zip.entries()");
        Enumeration<? extends ZipEntry> enumeration2 = enumeration;
        return SequencesKt.toSortedSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)kotlin.collections.CollectionsKt.iterator(enumeration2)), (Function1)findServiceLoaders.1.INSTANCE), (Function1)findServiceLoaders.2.INSTANCE), (Function1)findServiceLoaders.3.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, ServiceLoaderDependency>(this, zip, artifact){
            final /* synthetic */ FindServiceLoadersTask this$0;
            final /* synthetic */ ZipFile $zip;
            final /* synthetic */ ResolvedArtifactResult $artifact;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final ServiceLoaderDependency invoke(ZipEntry serviceFile) {
                ServiceLoaderDependency serviceLoaderDependency;
                void $this$filterTo$iv$iv;
                String it;
                Iterable $this$mapTo$iv$iv;
                Object p12;
                InputStream inputStream = this.$zip.getInputStream(serviceFile);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zip.getInputStream(serviceFile)");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    p12 = (BufferedReader)closeable;
                    boolean bl = false;
                    p12 = TextStreamsKt.readLines((Reader)((Reader)p12));
                }
                catch (Throwable p12) {
                    object = p12;
                    throw p12;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Iterable $this$map$iv = (Iterable)p12;
                boolean $i$f$map = false;
                p12 = $this$map$iv;
                Object destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void var12_18 = it;
                    String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)var12_18))).toString();
                    collection.add(string2);
                }
                Iterable $this$filterToSet$iv = (List)destination$iv$iv;
                boolean $i$f$filterToSet = false;
                $this$mapTo$iv$iv = $this$filterToSet$iv;
                destination$iv$iv = new HashSet<E>();
                int $i$f$filterTo = 0;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set providerClasses = (Set)destination$iv$iv;
                $this$filterToSet$iv = providerClasses;
                if (!$this$filterToSet$iv.isEmpty()) {
                    ZipEntry zipEntry = serviceFile;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"serviceFile");
                    String string = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serviceFile.name");
                    serviceLoaderDependency = new ServiceLoaderDependency(StringsKt.removePrefix((String)string, (CharSequence)"META-INF/services/"), providerClasses, this.$artifact);
                } else {
                    String string;
                    InputStream inputStream2 = this.$zip.getInputStream(serviceFile);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"zip.getInputStream(serviceFile)");
                    Closeable closeable2 = inputStream2;
                    object2 = Charsets.UTF_8;
                    destination$iv$iv = new InputStreamReader((InputStream)closeable2, (Charset)object2);
                    $i$f$filterTo = 8192;
                    closeable2 = destination$iv$iv instanceof BufferedReader ? (BufferedReader)destination$iv$iv : new BufferedReader((Reader)destination$iv$iv, $i$f$filterTo);
                    object2 = null;
                    try {
                        BufferedReader p13 = (BufferedReader)closeable2;
                        boolean bl = false;
                        string = TextStreamsKt.readText((Reader)p13);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
                    }
                    String contents = string;
                    Logger logger = this.this$0.getLogger();
                    StringBuilder stringBuilder = new StringBuilder();
                    File file = this.$artifact.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
                    StringBuilder stringBuilder2 = stringBuilder.append(file.getName()).append(" has a services file at path ");
                    ZipEntry zipEntry = serviceFile;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"serviceFile");
                    logger.debug(stringBuilder2.append(zipEntry.getName()).append(", but there are no services! ").append("File contents:\n<<").append(contents).append(">>").toString());
                    serviceLoaderDependency = null;
                }
                return serviceLoaderDependency;
            }
            {
                this.this$0 = findServiceLoadersTask2;
                this.$zip = zipFile;
                this.$artifact = resolvedArtifactResult;
                super(1);
            }
        })));
    }

    public FindServiceLoadersTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of all dependencies that include Java ServiceLoaders");
    }
}

