/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.KotlinClassHeaderBuilder;
import com.autonomousapps.internal.KotlinMetadataVisitor;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.model.InlineMemberCapability;
import com.autonomousapps.model.PhysicalArtifact;
import com.autonomousapps.model.intermediates.InlineMemberDependency;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.FindInlineMembersTask;
import com.autonomousapps.tasks.InlineMembersFinder;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/InlineMembersFinder;", "", "inMemoryCache", "Lcom/autonomousapps/services/InMemoryCache;", "artifacts", "", "Lcom/autonomousapps/model/PhysicalArtifact;", "(Lcom/autonomousapps/services/InMemoryCache;Ljava/util/List;)V", "logger", "Lorg/gradle/api/logging/Logger;", "find", "", "Lcom/autonomousapps/model/intermediates/InlineMemberDependency;", "findInlineMembers", "Lcom/autonomousapps/model/InlineMemberCapability$InlineMember;", "artifact", "inlineFunctions", "Lkotlin/sequences/Sequence;", "", "functions", "Lkotlinx/metadata/KmFunction;", "inlineMembers", "kmDeclaration", "Lkotlinx/metadata/KmDeclarationContainer;", "inlineProperties", "properties", "Lkotlinx/metadata/KmProperty;", "dependency-analysis-gradle-plugin"})
public final class InlineMembersFinder {
    private final Logger logger;
    private final InMemoryCache inMemoryCache;
    private final List<PhysicalArtifact> artifacts;

    @NotNull
    public final Set<InlineMemberDependency> find() {
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.artifacts), (Function1)find.1.INSTANCE), (Function1)((Function1)new Function1<PhysicalArtifact, Pair<? extends PhysicalArtifact, ? extends Set<? extends InlineMemberCapability.InlineMember>>>(this){
            final /* synthetic */ InlineMembersFinder this$0;

            @NotNull
            public final Pair<PhysicalArtifact, Set<InlineMemberCapability.InlineMember>> invoke(@NotNull PhysicalArtifact artifact) {
                Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                return TuplesKt.to((Object)artifact, (Object)InlineMembersFinder.access$findInlineMembers(this.this$0, artifact));
            }
            {
                this.this$0 = inlineMembersFinder;
                super(1);
            }
        })), (Function1)find.3.INSTANCE), (Function1)find.4.INSTANCE));
    }

    private final Set<InlineMemberCapability.InlineMember> findInlineMembers(PhysicalArtifact artifact) {
        boolean bl;
        List entries;
        Object object;
        ZipFile zipFile;
        block5: {
            String string = artifact.getFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.absolutePath");
            Set<InlineMemberCapability.InlineMember> alreadyFoundInlineMembers = this.inMemoryCache.inlineMember$dependency_analysis_gradle_plugin(string);
            if (alreadyFoundInlineMembers != null) {
                return alreadyFoundInlineMembers;
            }
            zipFile = new ZipFile(artifact.getFile());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
            object = enumeration;
            ArrayList<? extends ZipEntry> arrayList = Collections.list(object);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
            entries = arrayList;
            Iterable $this$none$iv = entries;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    boolean bl2 = false;
                    ZipEntry zipEntry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
                    String string2 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    if (!StringsKt.endsWith$default((String)string2, (String)".kotlin_module", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return SetsKt.emptySet();
        }
        Object it = object = SequencesKt.toSortedSet((Sequence)SequencesKt.mapNotNull(CollectionsKt.asSequenceOfClassFiles(entries), (Function1)((Function1)new Function1<ZipEntry, InlineMemberCapability.InlineMember>(this, zipFile){
            final /* synthetic */ InlineMembersFinder this$0;
            final /* synthetic */ ZipFile $zipFile;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final InlineMemberCapability.InlineMember invoke(@NotNull ZipEntry entry) {
                String string;
                Object inlineMembers;
                Object object;
                block27: {
                    block26: {
                        Set set2;
                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                        Closeable closeable = this.$zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            Object it = (InputStream)closeable;
                            boolean bl = false;
                            InputStream inputStream = it;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                            it = new ClassReader(ByteStreamsKt.readBytes((InputStream)inputStream));
                        }
                        catch (Throwable it) {
                            throwable = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        InputStream classReader = it;
                        KotlinMetadataVisitor metadataVisitor = new KotlinMetadataVisitor(InlineMembersFinder.access$getLogger$p(this.this$0));
                        classReader.accept(metadataVisitor, 0);
                        object = metadataVisitor.getBuilder$dependency_analysis_gradle_plugin();
                        if (object == null) break block26;
                        Object header = it = object;
                        boolean bl = false;
                        KotlinClassMetadata metadata = KotlinClassMetadata.Companion.read(((KotlinClassHeaderBuilder)header).build());
                        if (metadata instanceof KotlinClassMetadata.Class) {
                            set2 = InlineMembersFinder.access$inlineMembers(this.this$0, (KmDeclarationContainer)((KotlinClassMetadata.Class)metadata).toKmClass());
                        } else if (metadata instanceof KotlinClassMetadata.FileFacade) {
                            set2 = InlineMembersFinder.access$inlineMembers(this.this$0, (KmDeclarationContainer)((KotlinClassMetadata.FileFacade)metadata).toKmPackage());
                        } else if (metadata instanceof KotlinClassMetadata.MultiFileClassPart) {
                            set2 = InlineMembersFinder.access$inlineMembers(this.this$0, (KmDeclarationContainer)((KotlinClassMetadata.MultiFileClassPart)metadata).toKmPackage());
                        } else if (metadata instanceof KotlinClassMetadata.SyntheticClass) {
                            InlineMembersFinder.access$getLogger$p(this.this$0).debug("Ignoring SyntheticClass " + entry);
                            set2 = SetsKt.emptySet();
                        } else if (metadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
                            InlineMembersFinder.access$getLogger$p(this.this$0).debug("Ignoring MultiFileClassFacade " + entry);
                            set2 = SetsKt.emptySet();
                        } else if (metadata instanceof KotlinClassMetadata.Unknown) {
                            InlineMembersFinder.access$getLogger$p(this.this$0).debug("Ignoring Unknown " + entry);
                            set2 = SetsKt.emptySet();
                        } else if (metadata == null) {
                            InlineMembersFinder.access$getLogger$p(this.this$0).debug("Ignoring null " + entry);
                            set2 = SetsKt.emptySet();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object = set2;
                        if (set2 != null) break block27;
                    }
                    object = SetsKt.emptySet();
                }
                if ((inlineMembers = object).isEmpty()) {
                    return null;
                }
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                if (StringsKt.contains$default((CharSequence)string2, (char)'/', (boolean)false, (int)2, null)) {
                    String string3 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                    string = StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)string3, (char)'/', null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null);
                } else {
                    string = "";
                }
                String pn = string;
                return new InlineMemberCapability.InlineMember(pn, (Set<String>)inlineMembers);
            }
            {
                this.this$0 = inlineMembersFinder;
                this.$zipFile = zipFile;
                super(1);
            }
        })));
        boolean bl3 = false;
        String string = artifact.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.absolutePath");
        this.inMemoryCache.inlineMembers$dependency_analysis_gradle_plugin(string, (Set)it);
        return (Set)object;
    }

    private final Set<String> inlineMembers(KmDeclarationContainer kmDeclaration) {
        return SequencesKt.toSortedSet((Sequence)SequencesKt.plus(this.inlineFunctions(kmDeclaration.getFunctions()), this.inlineProperties(kmDeclaration.getProperties())));
    }

    private final Sequence<String> inlineFunctions(List<KmFunction> functions) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)functions), (Function1)inlineFunctions.1.INSTANCE), (Function1)inlineFunctions.2.INSTANCE);
    }

    private final Sequence<String> inlineProperties(List<KmProperty> properties) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)properties), (Function1)inlineProperties.1.INSTANCE), (Function1)inlineProperties.2.INSTANCE);
    }

    public InlineMembersFinder(@NotNull InMemoryCache inMemoryCache2, @NotNull List<PhysicalArtifact> artifacts) {
        Intrinsics.checkNotNullParameter((Object)inMemoryCache2, (String)"inMemoryCache");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        this.inMemoryCache = inMemoryCache2;
        this.artifacts = artifacts;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(FindInlineMembersTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(T::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ Set access$findInlineMembers(InlineMembersFinder $this, PhysicalArtifact artifact) {
        return $this.findInlineMembers(artifact);
    }

    public static final /* synthetic */ Logger access$getLogger$p(InlineMembersFinder $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Set access$inlineMembers(InlineMembersFinder $this, KmDeclarationContainer kmDeclaration) {
        return $this.inlineMembers(kmDeclaration);
    }
}

