/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.internal.analyzer.Language;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.declaration.SourceSetKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AbiAnalysisTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u00020\u0016H\u0002J\b\u00109\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020\u0016H\u0002J\b\u0010;\u001a\u00020\u0016H\u0002J\b\u0010<\u001a\u00020=H\u0002J\u001c\u0010>\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010?2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\n0BJ\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0?J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0?R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\fR\u0011\u0010,\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\fR\u0014\u00100\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\fR\u0014\u00102\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\fR\u0011\u00104\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\fR\u0011\u00106\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\f\u00a8\u0006G"}, d2={"Lcom/autonomousapps/internal/analyzer/JvmAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "sourceSet", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "hasAbi", "", "(Lorg/gradle/api/Project;Lcom/autonomousapps/internal/analyzer/JvmSourceSet;Z)V", "annotationProcessorConfigurationName", "", "getAnnotationProcessorConfigurationName", "()Ljava/lang/String;", "attributeValueJar", "getAttributeValueJar", "buildType", "getBuildType", "compileConfigurationName", "getCompileConfigurationName", "flavorName", "getFlavorName", "groovySourceFiles", "Lorg/gradle/api/file/FileCollection;", "getGroovySourceFiles", "()Lorg/gradle/api/file/FileCollection;", "isDataBindingEnabled", "()Z", "isViewBindingEnabled", "javaSourceFiles", "getJavaSourceFiles", "kaptConfigurationName", "getKaptConfigurationName", "kind", "Lcom/autonomousapps/model/declaration/SourceSetKind;", "getKind", "()Lcom/autonomousapps/model/declaration/SourceSetKind;", "kotlinSourceFiles", "getKotlinSourceFiles", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "runtimeConfigurationName", "getRuntimeConfigurationName", "scalaSourceFiles", "getScalaSourceFiles", "taskNameSuffix", "getTaskNameSuffix", "testJavaCompileName", "getTestJavaCompileName", "testKotlinCompileName", "getTestKotlinCompileName", "variantName", "getVariantName", "variantNameCapitalized", "getVariantNameCapitalized", "getGroovySources", "getJavaSources", "getKotlinSources", "getScalaSources", "getSourceDirectories", "Lorg/gradle/api/file/FileTree;", "registerAbiAnalysisTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/autonomousapps/tasks/AbiAnalysisTask;", "abiExclusions", "Lorg/gradle/api/provider/Provider;", "registerByteCodeSourceExploderTask", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nJvmProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/JvmAnalyzer\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,160:1\n254#2:161\n254#2:162\n254#2:163\n*S KotlinDebug\n*F\n+ 1 JvmProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/JvmAnalyzer\n*L\n54#1:161\n67#1:162\n80#1:163\n*E\n"})
public abstract class JvmAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final JvmSourceSet sourceSet;
    private final boolean hasAbi;
    @Nullable
    private final String flavorName;
    @Nullable
    private final String buildType;
    @NotNull
    private final SourceSetKind kind;
    @NotNull
    private final String variantName;
    @NotNull
    private final String variantNameCapitalized;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @NotNull
    private final String attributeValueJar;
    @NotNull
    private final FileCollection kotlinSourceFiles;
    @Nullable
    private final FileCollection javaSourceFiles;
    @NotNull
    private final FileCollection groovySourceFiles;
    @NotNull
    private final FileCollection scalaSourceFiles;
    private final boolean isDataBindingEnabled;
    private final boolean isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;
    @NotNull
    private final String testJavaCompileName;
    @NotNull
    private final String testKotlinCompileName;

    public JvmAnalyzer(@NotNull Project project, @NotNull JvmSourceSet sourceSet, boolean hasAbi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        super(project);
        this.sourceSet = sourceSet;
        this.hasAbi = hasAbi;
        this.kind = this.sourceSet.getKind();
        this.variantName = this.sourceSet.getName();
        this.taskNameSuffix = this.variantNameCapitalized = UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null);
        this.compileConfigurationName = this.sourceSet.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.sourceSet.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = "kapt";
        this.annotationProcessorConfigurationName = "annotationProcessor";
        this.attributeValueJar = "jar";
        this.kotlinSourceFiles = this.getKotlinSources();
        this.javaSourceFiles = this.getJavaSources();
        this.groovySourceFiles = this.getGroovySources();
        this.scalaSourceFiles = this.getScalaSources();
        this.outputPaths = new OutputPaths(project, this.variantName);
        this.testJavaCompileName = "compileTestJava";
        this.testKotlinCompileName = "compileTestKotlin";
    }

    @Override
    @Nullable
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @Nullable
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceSetKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getVariantNameCapitalized() {
        return this.variantNameCapitalized;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    @NotNull
    public final FileCollection getKotlinSourceFiles() {
        return this.kotlinSourceFiles;
    }

    @Override
    @Nullable
    public FileCollection getJavaSourceFiles() {
        return this.javaSourceFiles;
    }

    @Override
    @NotNull
    public final FileCollection getGroovySourceFiles() {
        return this.groovySourceFiles;
    }

    @Override
    @NotNull
    public final FileCollection getScalaSourceFiles() {
        return this.scalaSourceFiles;
    }

    @Override
    public final boolean isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    public final boolean isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    @Override
    @NotNull
    public OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    @Override
    @NotNull
    public final String getTestJavaCompileName() {
        return this.testJavaCompileName;
    }

    @Override
    @NotNull
    public final String getTestKotlinCompileName() {
        return this.testKotlinCompileName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeByteCodeSource" + this.variantNameCapitalized;
        Function1 configuration$iv = (Function1)new Function1<ClassListExploderTask, Unit>(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassListExploderTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getClasses().setFrom((Iterable)JvmAnalyzer.access$getSourceSet$p(this.this$0).getClassesDirs());
                $this$register.getJavaClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
                $this$register.getKotlinClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getExplodingBytecodePath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ClassListExploderTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final TaskProvider<AbiAnalysisTask> registerAbiAnalysisTask(@NotNull Provider<String> abiExclusions) {
        void name$iv;
        void $this$register$iv;
        Intrinsics.checkNotNullParameter(abiExclusions, (String)"abiExclusions");
        if (!this.hasAbi) {
            return null;
        }
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "abiAnalysis" + this.variantNameCapitalized;
        Function1 configuration$iv = (Function1)new Function1<AbiAnalysisTask, Unit>(this, abiExclusions){
            final /* synthetic */ JvmAnalyzer this$0;
            final /* synthetic */ Provider<String> $abiExclusions;
            {
                this.this$0 = $receiver;
                this.$abiExclusions = $abiExclusions;
                super(1);
            }

            public final void invoke(@NotNull AbiAnalysisTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getClasses().setFrom((Iterable)JvmAnalyzer.access$getSourceSet$p(this.this$0).getClassesDirs());
                $this$register.getJavaClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
                $this$register.getKotlinClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
                $this$register.getExclusions().set(this.$abiExclusions);
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAbiAnalysisPath());
                $this$register.getAbiDump().set(this.this$0.getOutputPaths().getAbiDumpPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, AbiAnalysisTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findDeclaredProcs" + this.variantNameCapitalized;
        Function1 configuration$iv = (Function1)new Function1<FindDeclaredProcsTask, Unit>(this){
            final /* synthetic */ JvmAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindDeclaredProcsTask $this$register) {
                Configuration it;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                Property<InMemoryCache> property = $this$register.getInMemoryCacheProvider();
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                property.set(InMemoryCache.Companion.register$dependency_analysis_gradle_plugin(project));
                Configuration configuration = this.this$0.kaptConf();
                if (configuration != null) {
                    it = configuration;
                    boolean bl = false;
                    ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setKaptArtifacts(artifactCollection);
                }
                Configuration configuration2 = this.this$0.annotationProcessorConf();
                if (configuration2 != null) {
                    it = configuration2;
                    boolean bl = false;
                    ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setAnnotationProcessorArtifacts(artifactCollection);
                }
                $this$register.getOutput().set(this.this$0.getOutputPaths().getDeclaredProcPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindDeclaredProcsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    private final FileCollection getGroovySources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.GROOVY));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026ilterOf(Language.GROOVY))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getJavaSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.JAVA));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026.filterOf(Language.JAVA))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getKotlinSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.KOTLIN));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026ilterOf(Language.KOTLIN))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getScalaSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.SCALA));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026filterOf(Language.SCALA))");
        return (FileCollection)fileTree;
    }

    private final FileTree getSourceDirectories() {
        FileCollection fileCollection = this.sourceSet.getSourceCode().getSourceDirectories();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceSet.sourceCode.sourceDirectories");
        FileCollection allSource = fileCollection;
        Object[] objectArray = new Object[]{allSource};
        FileTree fileTree = this.getProject().files(objectArray).getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.files(allSource).asFileTree");
        return fileTree;
    }

    public static final /* synthetic */ JvmSourceSet access$getSourceSet$p(JvmAnalyzer $this) {
        return $this.sourceSet;
    }
}

