/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DominanceTree;
import com.autonomousapps.graph.DominanceTreeWriter;
import com.autonomousapps.graph.Graphs;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.utils.FileUtils;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.PhysicalArtifact;
import com.autonomousapps.model.ProjectCoordinates;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graphView", "Lorg/gradle/api/file/RegularFileProperty;", "getGraphView", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "getOutputDot", "outputTxt", "getOutputTxt", "physicalArtifacts", "getPhysicalArtifacts", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "action", "", "BySize", "Companion", "dependency-analysis-gradle-plugin"})
public abstract class ComputeDominatorTreeTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ComputeDominatorTreeTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Computes a dominator view of the dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPhysicalArtifacts();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraphView();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputTxt();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @TaskAction
    public final void action() {
        ComputeDominatorTreeTask.Companion.compute((Property<String>)this.getProjectPath(), this.getOutputTxt(), this.getOutputDot(), this.getPhysicalArtifacts(), this.getGraphView());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize;", "Lcom/autonomousapps/graph/DominanceTreeWriter$NodeWriter;", "Lcom/autonomousapps/model/Coordinates;", "files", "", "Ljava/io/File;", "tree", "Lcom/autonomousapps/graph/DominanceTree;", "root", "(Ljava/util/Map;Lcom/autonomousapps/graph/DominanceTree;Lcom/autonomousapps/model/Coordinates;)V", "comparator", "Ljava/util/Comparator;", "reachableNodes", "", "", "scale", "Lcom/autonomousapps/internal/utils/FileUtils$Scale;", "sizes", "", "Lkotlin/Comparator;", "getSize", "node", "toString", "", "treeSizeOf", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1603#2,9:160\n1855#2:169\n1856#2:171\n1612#2:172\n1603#2,9:174\n1855#2:183\n1856#2:185\n1612#2:186\n1603#2,9:188\n1855#2:197\n1856#2:199\n1612#2:200\n1#3:170\n1#3:173\n1#3:184\n1#3:187\n1#3:198\n1#3:201\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$BySize\n*L\n77#1:160,9\n77#1:169\n77#1:171\n77#1:172\n72#1:174,9\n72#1:183\n72#1:185\n72#1:186\n95#1:188,9\n95#1:197\n95#1:199\n95#1:200\n77#1:170\n72#1:184\n95#1:198\n*E\n"})
    private static final class BySize
    implements DominanceTreeWriter.NodeWriter<Coordinates> {
        @NotNull
        private final Map<Coordinates, File> files;
        @NotNull
        private final DominanceTree<Coordinates> tree;
        @NotNull
        private final Map<Coordinates, Long> sizes;
        @NotNull
        private final Map<Coordinates, Set<Coordinates>> reachableNodes;
        @NotNull
        private final FileUtils.Scale scale;
        @NotNull
        private final Comparator<Coordinates> comparator;

        /*
         * WARNING - void declaration
         */
        public BySize(@NotNull Map<Coordinates, ? extends File> files, @NotNull DominanceTree<Coordinates> tree, @NotNull Coordinates root) {
            void it;
            long l;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.files = files;
            this.tree = tree;
            this.sizes = new LinkedHashMap();
            this.reachableNodes = new LinkedHashMap();
            Iterable iterable = this.reachableNodes(root);
            BySize bySize = this;
            boolean $i$f$mapNotNull22 = false;
            void var6_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it2 = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            long $i$f$mapNotNull22 = 0L;
            for (Object e : iterable) {
                void it3;
                $this$forEach$iv$iv$iv = (File)e;
                l = $i$f$mapNotNull22;
                boolean bl = false;
                long l2 = it3.length();
                $i$f$mapNotNull22 = l + l2;
            }
            $i$f$mapNotNull22 = l = $i$f$mapNotNull22;
            boolean bl = false;
            bySize.scale = FileUtils.INSTANCE.getScale((long)it);
            this.comparator = new Comparator(this){
                final /* synthetic */ BySize this$0;
                {
                    this.this$0 = $receiver;
                }

                public final int compare(Coordinates left, Coordinates right) {
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    long l = BySize.access$getSize(this.this$0, right);
                    Intrinsics.checkNotNullExpressionValue((Object)left, (String)"left");
                    return Intrinsics.compare((long)l, (long)BySize.access$getSize(this.this$0, left));
                }
            };
        }

        private final long getSize(Coordinates node) {
            Long l = this.sizes.computeIfAbsent(node, new Function(this){
                final /* synthetic */ BySize this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public final Long apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BySize.access$treeSizeOf(this.this$0, it);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"private fun getSize(node\u2026(node) { treeSizeOf(it) }");
            return ((Number)l).longValue();
        }

        private final Set<Coordinates> reachableNodes(Coordinates node) {
            Set<Coordinates> set2 = this.reachableNodes.computeIfAbsent(node, new Function(this, node){
                final /* synthetic */ BySize this$0;
                final /* synthetic */ Coordinates $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                }

                @NotNull
                public final Set<Coordinates> apply(@NotNull Coordinates it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Graphs.INSTANCE.reachableNodes(BySize.access$getTree$p(this.this$0).getDominanceGraph(), (Object)this.$node, false);
                }
            });
            Intrinsics.checkNotNullExpressionValue(set2, (String)"private fun reachableNod\u2026xcludeSelf = false)\n    }");
            return set2;
        }

        /*
         * WARNING - void declaration
         */
        private final long treeSizeOf(Coordinates node) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.reachableNodes(node);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Coordinates it = (Coordinates)element$iv$iv;
                boolean bl2 = false;
                if (this.files.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            long l = 0L;
            for (Object t : iterable2) {
                void it;
                $this$forEach$iv$iv$iv = (File)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.length();
                l = l2 + l3;
            }
            return l;
        }

        @NotNull
        public Comparator<Coordinates> comparator() {
            return this.comparator;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString(@NotNull Coordinates node) {
            File totalSize2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StringBuilder builder = new StringBuilder();
            boolean printedTotalSize = false;
            Set<Coordinates> subs = this.reachableNodes(node);
            if (!((Collection)SetsKt.minus(subs, (Object)node)).isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = subs;
                boolean $i$f$mapNotNull = false;
                void var10_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                File $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    File it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Coordinates it = (Coordinates)element$iv$iv;
                    boolean bl2 = false;
                    if (this.files.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
                long l = 0L;
                for (Object $i$f$mapNotNullTo2 : iterable) {
                    void it;
                    $this$forEach$iv$iv$iv = (File)$i$f$mapNotNullTo2;
                    long l2 = l;
                    boolean bl = false;
                    long l3 = it.length();
                    l = l2 + l3;
                }
                long totalSize2 = l;
                printedTotalSize = true;
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(totalSize2, this.scale)).append(' ');
            }
            if ((totalSize2 = this.files.get(node)) != null) {
                long it = totalSize2.length();
                boolean bl = false;
                if (printedTotalSize) {
                    builder.append('(');
                }
                builder.append(FileUtils.INSTANCE.byteCountToDisplaySize(it, this.scale));
                if (printedTotalSize) {
                    builder.append(')');
                }
                builder.append(' ');
            }
            Coordinates preferredCoordinatesNotation = node instanceof IncludedBuildCoordinates ? (Coordinates)((IncludedBuildCoordinates)node).getResolvedProject() : node;
            builder.append(preferredCoordinatesNotation.gav());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        public static final /* synthetic */ long access$treeSizeOf(BySize $this, Coordinates node) {
            return $this.treeSizeOf(node);
        }

        public static final /* synthetic */ DominanceTree access$getTree$p(BySize $this) {
            return $this.tree;
        }

        public static final /* synthetic */ long access$getSize(BySize $this, Coordinates node) {
            return $this.getSize(node);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion;", "", "()V", "compute", "", "projectPath", "Lorg/gradle/api/provider/Property;", "", "outputTxt", "Lorg/gradle/api/file/RegularFileProperty;", "outputDot", "physicalArtifacts", "graphView", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nComputeDominatorTreeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n34#2,8:160\n105#2,13:181\n47#3,3:168\n31#3,4:171\n38#3,2:194\n31#3,4:196\n1179#4,2:175\n1253#4,4:177\n*S KotlinDebug\n*F\n+ 1 ComputeDominatorTreeTask.kt\ncom/autonomousapps/tasks/ComputeDominatorTreeTask$Companion\n*L\n133#1:160,8\n137#1:181,13\n133#1:168,3\n133#1:171,4\n137#1:194,2\n137#1:196,4\n133#1:175,2\n133#1:177,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void compute(Property<String> projectPath, RegularFileProperty outputTxt, RegularFileProperty outputDot, RegularFileProperty physicalArtifacts, RegularFileProperty graphView) {
            Object object;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Set set2;
            File outputTxt2 = UtilsKt.getAndDelete(outputTxt);
            File outputDot2 = UtilsKt.getAndDelete(outputDot);
            Object $this$fromJsonSet$iv = physicalArtifacts;
            boolean $i$f$fromJsonSet = false;
            Object object2 = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
            RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJsonSet22 = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead(file);
            Throwable throwable = null;
            try {
                BufferedSource reader$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{PhysicalArtifact.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                set2 = (Set)object3;
            }
            catch (Throwable reader$iv$iv) {
                throwable = reader$iv$iv;
                throw reader$iv$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJsonSet$iv = set2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void $i$f$fromJsonSet22 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                PhysicalArtifact $i$f$getJsonSetAdapter = (PhysicalArtifact)element$iv$iv;
                boolean bl = false;
                Coordinates coord2 = $i$f$getJsonSetAdapter.component1();
                File file2 = $i$f$getJsonSetAdapter.component2();
                $i$f$getJsonSetAdapter = TuplesKt.to((Object)coord2, (Object)file2);
                map.put($i$f$getJsonSetAdapter.getFirst(), $i$f$getJsonSetAdapter.getSecond());
            }
            Map artifactMap = destination$iv$iv;
            RegularFileProperty $this$fromJson$iv = graphView;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson2 = false;
            File file3 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file3;
            boolean $i$f$fromJson3 = false;
            Closeable closeable2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable2 = null;
            try {
                BufferedSource reader$iv$iv$iv = (BufferedSource)closeable2;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(DependencyGraphView.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object5);
                object = object5;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            DependencyGraphView graphView2 = (DependencyGraphView)object;
            Object object6 = projectPath.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"projectPath.get()");
            ProjectCoordinates project = new ProjectCoordinates((String)object6, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), ":");
            DominanceTree tree = new DominanceTree(graphView2.getGraph$dependency_analysis_gradle_plugin(), (Object)project);
            BySize nodeWriter = new BySize(artifactMap, (DominanceTree<Coordinates>)tree, project);
            DominanceTreeWriter writer = new DominanceTreeWriter((Object)project, tree, (DominanceTreeWriter.NodeWriter)nodeWriter);
            FilesKt.writeText$default((File)outputTxt2, (String)writer.getString(), null, (int)2, null);
            FilesKt.writeText$default((File)outputDot2, (String)GraphWriter.INSTANCE.toDot((Graph<Coordinates>)tree.getDominanceGraph()), null, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

