/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.AndroidManifestCapability;
import com.autonomousapps.model.intermediates.AndroidManifestDependency;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004J0\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00160\u0014*\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00160\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "manifestArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "namespace", "Lorg/gradle/api/provider/Property;", "", "getNamespace", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "getManifestFiles", "Lorg/gradle/api/file/FileCollection;", "setArtifacts", "toComponentMap", "", "Lcom/autonomousapps/model/AndroidManifestCapability$Component;", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nManifestComponentsExtractionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestComponentsExtractionTask.kt\ncom/autonomousapps/tasks/ManifestComponentsExtractionTask\n+ 2 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n130#2:74\n1611#3:75\n1855#3:76\n1856#3:78\n1612#3:79\n1#4:77\n173#5,3:80\n49#5,3:83\n33#5,4:86\n176#5,2:90\n125#6:92\n152#6,3:93\n*S KotlinDebug\n*F\n+ 1 ManifestComponentsExtractionTask.kt\ncom/autonomousapps/tasks/ManifestComponentsExtractionTask\n*L\n51#1:74\n51#1:75\n51#1:76\n51#1:78\n51#1:79\n51#1:77\n63#1:80,3\n63#1:83,3\n63#1:86,4\n63#1:90,2\n67#1:92\n67#1:93,3\n*E\n"})
public abstract class ManifestComponentsExtractionTask
extends DefaultTask {
    private ArtifactCollection manifestArtifacts;

    public ManifestComponentsExtractionTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of packages, from other components, that are included via Android manifests");
    }

    public final void setArtifacts(@NotNull ArtifactCollection manifestArtifacts) {
        Intrinsics.checkNotNullParameter((Object)manifestArtifacts, (String)"manifestArtifacts");
        this.manifestArtifacts = manifestArtifacts;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getManifestFiles() {
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
            artifactCollection = null;
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"manifestArtifacts.artifactFiles");
        return fileCollection;
    }

    @Input
    @NotNull
    public abstract Property<String> getNamespace();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Object object = this.getNamespace().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"namespace.get()");
        ManifestParser parser = new ManifestParser((String)object);
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
            artifactCollection = null;
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AndroidManifestDependency it$iv$iv;
            AndroidManifestDependency androidManifestDependency;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            try {
                File file = manifest.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifest.file");
                ManifestParser.ParseResult parseResult = parser.parse(file, true);
                Map<AndroidManifestCapability.Component, Set<String>> map = this.toComponentMap(parseResult.getComponents());
                Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
                androidManifestDependency = new AndroidManifestDependency(map, manifest);
            }
            catch (GradleException gradleException) {
                androidManifestDependency = null;
            }
            if (androidManifestDependency == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set manifests = (Set)destination$iv$iv;
        File $this$bufferWriteJsonSet_u24default$iv = outputFile;
        String indent$iv = "";
        boolean $i$f$bufferWriteJsonSet = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonSetAdapter = false;
            element$iv$iv = new Type[]{AndroidManifestDependency.class};
            ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), element$iv$iv);
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)manifests);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<AndroidManifestCapability.Component, Set<String>> toComponentMap(Map<String, ? extends Set<String>> $this$toComponentMap) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends Set<String>> $this$map$iv = $this$toComponentMap;
        boolean $i$f$map = false;
        Map<String, ? extends Set<String>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            collection.add(TuplesKt.to((Object)((Object)AndroidManifestCapability.Component.Companion.of$dependency_analysis_gradle_plugin(key)), (Object)values));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

