/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.reason.DependencyAdviceExplainer;
import com.autonomousapps.internal.reason.ModuleAdviceExplainer;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.CoordinatesStringsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.DependencyGraphView;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.intermediates.BundleTrace;
import com.autonomousapps.model.intermediates.Usage;
import com.autonomousapps.tasks.ReasonTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0006-./012B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020\u0012H\u0002J\b\u0010+\u001a\u00020,H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR*\u0010\u001a\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u00128G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u00128G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/autonomousapps/tasks/ReasonTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "annotationProcessorUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "getDependencyUsageReport", "finalAdviceReport", "getFinalAdviceReport", "<set-?>", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "module", "getModule", "setModule", "projectPath", "Lorg/gradle/api/provider/Property;", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "action", "", "help", "options", "Lcom/autonomousapps/tasks/ReasonTask$Options;", "ExplainDependencyAdviceAction", "ExplainDependencyAdviceParams", "ExplainModuleAdviceAction", "ExplainModuleAdviceParams", "Explainer", "Options", "dependency-analysis-gradle-plugin"})
public abstract class ReasonTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @Nullable
    private String id;
    @Nullable
    private String module;

    @Inject
    public ReasonTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Explain how a dependency is used");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Optional
    @Input
    @Nullable
    public final String getId() {
        return this.id;
    }

    @Option(option="id", description="The dependency you'd like to reason about (com.foo:bar:1.0 or :other:module)")
    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getModule() {
        return this.module;
    }

    @Option(option="module", description="The module-structure-related advice you'd like more insight into ('android')")
    public final void setModule(@Nullable String string) {
        this.module = string;
    }

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getDependencyUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAnnotationProcessorUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getUnfilteredAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getFinalAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleTracesReport();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyGraphViews();

    @TaskAction
    public final void action() {
        block1: {
            Options options = this.options();
            String string = options.getId();
            if (string != null) {
                String dependency = string;
                boolean bl = false;
                this.workerExecutor.noIsolation().submit(ExplainDependencyAdviceAction.class, new Action(dependency, this){
                    final /* synthetic */ String $dependency;
                    final /* synthetic */ ReasonTask this$0;
                    {
                        this.$dependency = $dependency;
                        this.this$0 = $receiver;
                    }

                    public final void execute(@NotNull ExplainDependencyAdviceParams $this$submit) {
                        Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                        $this$submit.getId().set((Object)this.$dependency);
                        $this$submit.getProjectPath().set((Provider)this.this$0.getProjectPath());
                        $this$submit.getDependencyMap().set((Provider)this.this$0.getDependencyMap());
                        $this$submit.getDependencyUsageReport().set((Provider)this.this$0.getDependencyUsageReport());
                        $this$submit.getAnnotationProcessorUsageReport().set((Provider)this.this$0.getAnnotationProcessorUsageReport());
                        $this$submit.getUnfilteredAdviceReport().set((Provider)this.this$0.getUnfilteredAdviceReport());
                        $this$submit.getFinalAdviceReport().set((Provider)this.this$0.getFinalAdviceReport());
                        $this$submit.getBundleTracesReport().set((Provider)this.this$0.getBundleTracesReport());
                        $this$submit.getDependencyGraphViews().set((Provider)this.this$0.getDependencyGraphViews());
                    }
                });
            }
            String string2 = options.getModule();
            if (string2 == null) break block1;
            String moduleStructure = string2;
            boolean bl = false;
            this.workerExecutor.noIsolation().submit(ExplainModuleAdviceAction.class, new Action(moduleStructure, this){
                final /* synthetic */ String $moduleStructure;
                final /* synthetic */ ReasonTask this$0;
                {
                    this.$moduleStructure = $moduleStructure;
                    this.this$0 = $receiver;
                }

                public final void execute(@NotNull ExplainModuleAdviceParams $this$submit) {
                    Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                    $this$submit.getModule().set((Object)this.$moduleStructure);
                    $this$submit.getProjectPath().set((Provider)this.this$0.getProjectPath());
                    $this$submit.getUnfilteredAdviceReport().set((Provider)this.this$0.getUnfilteredAdviceReport());
                    $this$submit.getFinalAdviceReport().set((Provider)this.this$0.getFinalAdviceReport());
                }
            });
        }
    }

    private final Options options() {
        String id = this.id;
        String module = this.module;
        if (id == null && module == null) {
            throw new InvalidUserDataException(this.help());
        }
        return new Options(id, module);
    }

    private final String help() {
        String path = (String)this.getProjectPath().get();
        boolean bl = false;
        return StringsKt.trimIndent((String)("\n      You must call 'reason' with either the `--id` or `--module` option, or both.\n      \n      Usage for --id:\n        ./gradlew " + path + ":reason --id com.foo:bar:1.0\n        ./gradlew " + path + ":reason --id :other:module\n        \n      For external dependencies, the version is optional.\n      \n      Usage for --module:\n        ./gradlew " + path + ":reason --module android\n    "));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010%\u001a\u00020\u0006H\u0002J\b\u0010&\u001a\u00020#H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "()V", "annotationProcessorUsages", "", "", "", "Lcom/autonomousapps/model/intermediates/Usage;", "coord", "Lcom/autonomousapps/model/Coordinates;", "dependencyGraph", "Lcom/autonomousapps/model/DependencyGraphView;", "dependencyMap", "Lkotlin/Function1;", "dependencyUsages", "finalAdvice", "Lcom/autonomousapps/model/Advice;", "finalProjectAdvice", "Lcom/autonomousapps/model/ProjectAdvice;", "logger", "Lorg/gradle/api/logging/Logger;", "projectPath", "requestedCoord", "unfilteredAdvice", "unfilteredProjectAdvice", "usages", "bundleTraces", "Lcom/autonomousapps/model/intermediates/BundleTrace;", "execute", "", "findAdviceIn", "projectAdvice", "getRequestedCoordinates", "normalize", "", "getUsageFor", "id", "wasFiltered", "Companion", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,329:1\n21#2:330\n1549#3:331\n1620#3,2:332\n1622#3:348\n1194#3,2:349\n1222#3,4:351\n857#3,2:462\n122#4,8:334\n117#4,13:355\n117#4,13:374\n76#4,17:393\n76#4,17:419\n46#4,8:446\n40#5,2:342\n33#5,4:344\n40#5,2:368\n33#5,4:370\n40#5,2:387\n33#5,4:389\n96#5:410\n59#5,4:411\n33#5,4:415\n96#5:436\n59#5,4:437\n33#5,4:441\n49#5,3:454\n33#5,4:457\n1#6:445\n70#7:461\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n*L\n164#1:330\n168#1:331\n168#1:332,2\n168#1:348\n169#1:349,2\n169#1:351,4\n251#1:462,2\n168#1:334,8\n170#1:355,13\n171#1:374,13\n174#1:393,17\n175#1:419,17\n251#1:446,8\n168#1:342,2\n168#1:344,4\n170#1:368,2\n170#1:370,4\n171#1:387,2\n171#1:389,4\n174#1:410\n174#1:411,4\n174#1:415,4\n175#1:436\n175#1:437,4\n175#1:441,4\n251#1:454,3\n251#1:457,4\n251#1:461\n*E\n"})
    public static abstract class ExplainDependencyAdviceAction
    implements WorkAction<ExplainDependencyAdviceParams> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Logger logger;
        @NotNull
        private final String projectPath;
        @NotNull
        private final Map<String, DependencyGraphView> dependencyGraph;
        @NotNull
        private final ProjectAdvice unfilteredProjectAdvice;
        @NotNull
        private final ProjectAdvice finalProjectAdvice;
        @NotNull
        private final Function1<String, String> dependencyMap;
        @NotNull
        private final Map<String, Set<Usage>> dependencyUsages;
        @NotNull
        private final Map<String, Set<Usage>> annotationProcessorUsages;
        @NotNull
        private final Coordinates coord;
        @NotNull
        private final Coordinates requestedCoord;
        @Nullable
        private final Advice finalAdvice;
        @Nullable
        private final Advice unfilteredAdvice;
        @NotNull
        private final Set<Usage> usages;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainDependencyAdviceAction() {
            boolean $i$f$withNulls;
            Type[] $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl;
            BufferedSource reader$iv$iv$iv2;
            RegularFileProperty $this$fromJson$iv;
            Object element$iv$iv2;
            void $this$associateByTo$iv$iv;
            RegularFileProperty $this$associateBy$iv;
            Object object;
            Object object2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
            this.logger = logger;
            Object object3 = ((ExplainDependencyAdviceParams)this.getParameters()).getProjectPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.projectPath.get()");
            this.projectPath = (String)object3;
            Object object4 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyGraphViews().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.dependencyGraphViews.get()");
            Iterable $i$f$getLogger22 = (Iterable)object4;
            ExplainDependencyAdviceAction explainDependencyAdviceAction = this;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                Object object5;
                File $this$fromJson$iv$iv;
                void it;
                RegularFile regularFile = (RegularFile)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                void $this$fromJson$iv2 = it;
                boolean $i$f$fromJson = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv2.getAsFile(), (String)"asFile");
                boolean $i$f$fromJson2 = false;
                Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv);
                object = null;
                try {
                    JsonAdapter $this$withNulls$iv$iv$iv$iv;
                    BufferedSource reader$iv$iv = (BufferedSource)closeable;
                    boolean bl3 = false;
                    boolean withNulls$iv$iv$iv = false;
                    boolean $i$f$getJsonAdapter2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyGraphView.class), (String)"MOSHI.adapter(T::class.java)");
                    boolean $i$f$withNulls2 = false;
                    Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                object2.add((DependencyGraphView)object5);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                DependencyGraphView bl2 = (DependencyGraphView)element$iv$iv2;
                object2 = destination$iv$iv2;
                boolean bl4 = false;
                object2.put(it.getName() + "," + it.getConfigurationName(), element$iv$iv2);
            }
            explainDependencyAdviceAction.dependencyGraph = destination$iv$iv2;
            $this$associateBy$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            explainDependencyAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object6;
            boolean $i$f$fromJson3 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)item$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                Type[] typeArray = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = typeArray;
                $i$f$withNulls = false;
                Object object7 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object7);
                object = object7;
            }
            catch (Throwable reader$iv$iv$iv2) {
                element$iv$iv2 = reader$iv$iv$iv2;
                throw reader$iv$iv$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.unfilteredProjectAdvice = (ProjectAdvice)object;
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object8 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get()");
            $this$fromJson$iv$iv = (RegularFile)object8;
            $i$f$fromJson3 = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)item$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object9 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object9);
                object = object9;
            }
            catch (Throwable reader$iv$iv$iv3) {
                element$iv$iv2 = reader$iv$iv$iv3;
                throw reader$iv$iv$iv3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.finalProjectAdvice = (ProjectAdvice)object;
            Object object10 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"parameters.dependencyMap.get()");
            this.dependencyMap = DependenciesHandler.Companion.toLambda((Map)object10);
            RegularFileProperty $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyUsageReport();
            boolean $i$f$fromJsonMapSet = false;
            Object object11 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"get()");
            RegularFile $this$fromJsonMapSet$iv$iv = (RegularFile)object11;
            boolean $i$f$fromJsonMapSet2 = false;
            File file3 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
            File $this$fromJsonMapSet$iv$iv$iv = file3;
            boolean $i$f$fromJsonMapSet3 = false;
            BufferedSource $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            boolean $i$f$fromJsonMapSet4 = false;
            boolean withNulls$iv$iv$iv$iv$iv = false;
            boolean $i$f$getJsonMapSetAdapter = false;
            Type[] withNulls$iv$iv$iv$iv2 = new Type[]{Usage.class};
            ParameterizedType setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])withNulls$iv$iv$iv$iv2);
            $this$withNulls$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            Object mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv);
            Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter<Map<K, Set<V>>>(mapType)");
            Type[] $this$withNulls$iv$iv$iv$iv$iv$iv = typeArray;
            $i$f$withNulls = false;
            Object object12 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object12);
            this.dependencyUsages = (Map)object12;
            $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getAnnotationProcessorUsageReport();
            $i$f$fromJsonMapSet = false;
            Object object13 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"get()");
            $this$fromJsonMapSet$iv$iv = (RegularFile)object13;
            $i$f$fromJsonMapSet2 = false;
            File file4 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"asFile");
            $this$fromJsonMapSet$iv$iv$iv = file4;
            $i$f$fromJsonMapSet3 = false;
            $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            $i$f$fromJsonMapSet4 = false;
            withNulls$iv$iv$iv$iv$iv = false;
            $i$f$getJsonMapSetAdapter = false;
            mapType$iv$iv$iv$iv$iv = new Type[]{Usage.class};
            setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])mapType$iv$iv$iv$iv$iv);
            $this$withNulls$iv$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv$iv);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"MOSHI.adapter<Map<K, Set<V>>>(mapType)");
            $this$withNulls$iv$iv$iv$iv$iv$iv = typeArray2;
            $i$f$withNulls = false;
            Object object14 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object14);
            this.annotationProcessorUsages = (Map)object14;
            this.coord = this.getRequestedCoordinates(true);
            this.requestedCoord = this.getRequestedCoordinates(false);
            this.finalAdvice = this.findAdviceIn(this.finalProjectAdvice);
            this.unfilteredAdvice = this.findAdviceIn(this.unfilteredProjectAdvice);
            this.usages = this.getUsageFor(this.coord.gav());
        }

        public void execute() {
            String reason = new DependencyAdviceExplainer(new ProjectCoordinates(this.projectPath, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), ":"), this.requestedCoord, this.coord, this.usages, this.finalAdvice, this.dependencyGraph, this.bundleTraces(), this.wasFiltered(), this.dependencyMap).computeReason();
            this.logger.quiet(reason);
        }

        private final Coordinates getRequestedCoordinates(boolean normalize) {
            String string;
            Object object = ((ExplainDependencyAdviceParams)this.getParameters()).getId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.id.get()");
            String requestedId = (String)object;
            boolean requestedViaProjectPath = StringsKt.startsWith$default((String)requestedId, (String)":", (boolean)false, (int)2, null);
            String string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.dependencyUsages.entrySet(), requestedId);
            if (string2 == null && (string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.annotationProcessorUsages.entrySet(), requestedId)) == null && (string2 = ExplainDependencyAdviceAction.getRequestedCoordinates$findInGraph(this, requestedId)) == null) {
                throw new InvalidUserDataException("There is no dependency with coordinates '" + requestedId + "' in this project.");
            }
            String gavKey = string2;
            if (requestedViaProjectPath && !normalize) {
                string = CoordinatesStringsKt.secondCoordinatesKeySegment(gavKey);
                if (string == null) {
                    string = gavKey;
                }
            } else {
                string = CoordinatesStringsKt.firstCoordinatesKeySegment(gavKey);
            }
            String gav2 = string;
            return Coordinates.Companion.of(gav2);
        }

        private final Set<Usage> getUsageFor(String id) {
            Set<Usage> set2;
            Object v0;
            block3: {
                Iterable iterable = this.dependencyUsages.entrySet();
                for (Object t : iterable) {
                    Map.Entry p0 = (Map.Entry)t;
                    boolean bl = false;
                    if (!CoordinatesStringsKt.equalsKey(id, p0)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((set2 = (Map.Entry)v0) == null || (set2 = (Set<Usage>)set2.getValue()) == null || (set2 = CollectionsKt.softSortedSet((Collection)set2, Usage.Companion.getBY_VARIANT())) == null) {
                Object object;
                Object v2;
                block4: {
                    Iterable iterable = this.annotationProcessorUsages.entrySet();
                    for (Object t : iterable) {
                        Map.Entry p0 = (Map.Entry)t;
                        boolean bl = false;
                        if (!CoordinatesStringsKt.equalsKey(id, p0)) continue;
                        v2 = t;
                        break block4;
                    }
                    v2 = null;
                }
                set2 = (object = (Map.Entry)v2) != null && (object = (Set)object.getValue()) != null ? CollectionsKt.softSortedSet((Collection)object, Usage.Companion.getBY_VARIANT()) : SetsKt.emptySet();
            }
            return set2;
        }

        private final Advice findAdviceIn(ProjectAdvice projectAdvice2) {
            Object v0;
            block1: {
                Iterable iterable = projectAdvice2.getDependencyAdvice();
                for (Object t : iterable) {
                    Advice advice = (Advice)t;
                    boolean bl = false;
                    String adviceGav = advice.getCoordinates().gav();
                    if (!(Intrinsics.areEqual((Object)adviceGav, (Object)this.coord.gav()) || Intrinsics.areEqual((Object)adviceGav, (Object)this.requestedCoord.gav()))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Set<BundleTrace> bundleTraces() {
            void $this$filterTo$iv$iv;
            Set set2;
            RegularFileProperty $this$fromJsonSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getBundleTracesReport();
            boolean $i$f$fromJsonSet = false;
            Object object = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
            Object $this$fromJsonSet$iv$iv = (RegularFile)object;
            boolean $i$f$fromJsonSet2 = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead(file);
            Object object2 = null;
            try {
                BufferedSource reader$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{BundleTrace.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                set2 = (Set)object3;
            }
            catch (Throwable reader$iv$iv) {
                object2 = reader$iv$iv;
                throw reader$iv$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            Iterable $this$filterToSet$iv = set2;
            boolean $i$f$filterToSet = false;
            $this$fromJsonSet$iv$iv = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BundleTrace it = (BundleTrace)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTop(), (Object)this.coord) || Intrinsics.areEqual((Object)it.getBottom(), (Object)this.coord))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean wasFiltered() {
            return this.finalAdvice == null && this.unfilteredAdvice != null;
        }

        private static final String getRequestedCoordinates$findInGraph(ExplainDependencyAdviceAction this$0, String requestedId) {
            Object v1;
            block1: {
                Sequence sequence = SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this$0.dependencyGraph.values()), (Function1)getRequestedCoordinates.findInGraph.1.INSTANCE);
                for (Object e : sequence) {
                    Coordinates coordinates = (Coordinates)e;
                    boolean bl = false;
                    String gav2 = coordinates.gav();
                    boolean bl2 = Intrinsics.areEqual((Object)gav2, (Object)requestedId) || StringsKt.startsWith$default((String)gav2, (String)(requestedId + ":"), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)gav2), (Object)requestedId) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)coordinates.getIdentifier()), (Object)requestedId);
                    if (!bl2) continue;
                    v1 = e;
                    break block1;
                }
                v1 = null;
            }
            Coordinates coordinates = v1;
            return coordinates != null ? coordinates.gav() : null;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion;", "", "()V", "findFilteredDependencyKey", "", "dependencies", "", "", "requestedId", "findFilteredDependencyKey$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
        @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1549#2:330\n1620#2,3:331\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n*L\n275#1:330\n275#1:331,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String findFilteredDependencyKey$dependency_analysis_gradle_plugin(@NotNull Set<? extends Map.Entry<String, ? extends Object>> dependencies2, @NotNull String requestedId) {
                String string;
                Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
                Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
                LinkedHashSet<String> filteredKeys = new LinkedHashSet<String>();
                for (Map.Entry<String, ? extends Object> entry : dependencies2) {
                    if (CoordinatesStringsKt.equalsKey(requestedId, entry)) {
                        return entry.getKey();
                    }
                    if (!CoordinatesStringsKt.matchesKey(requestedId, entry)) continue;
                    filteredKeys.add(entry.getKey());
                }
                if (filteredKeys.isEmpty()) {
                    string = null;
                } else if (filteredKeys.size() == 1) {
                    string = (String)filteredKeys.iterator().next();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = filteredKeys;
                    String string2 = requestedId;
                    boolean bl = false;
                    void var6_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string4 = CoordinatesStringsKt.secondCoordinatesKeySegment((String)it);
                        if (string4 == null) {
                            string4 = it;
                        }
                        collection.add(string4);
                    }
                    String string5 = "Coordinates '" + string2 + "' matches more than 1 dependency " + (List)destination$iv$iv;
                    throw new InvalidUserDataException(string5);
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0012\u0010\u001c\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "annotationProcessorUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleTracesReport", "getBundleTracesReport", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "getDependencyUsageReport", "finalAdviceReport", "getFinalAdviceReport", "id", "Lorg/gradle/api/provider/Property;", "getId", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainDependencyAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getId();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public RegularFileProperty getDependencyUsageReport();

        @NotNull
        public RegularFileProperty getAnnotationProcessorUsageReport();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();

        @NotNull
        public RegularFileProperty getBundleTracesReport();

        @NotNull
        public ListProperty<RegularFile> getDependencyGraphViews();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u0015\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "()V", "finalAndroidScore", "Lcom/autonomousapps/model/AndroidScore;", "Lkotlin/internal/NoInfer;", "logger", "Lorg/gradle/api/logging/Logger;", "module", "", "projectPath", "unfilteredAndroidScore", "execute", "", "validateModuleOption", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n21#2:330\n117#3,13:331\n117#3,13:361\n40#4,2:344\n33#4,4:346\n40#4,2:374\n33#4,4:376\n800#5,11:350\n800#5,11:380\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n*L\n290#1:330\n295#1:331,13\n300#1:361,13\n295#1:344,2\n295#1:346,4\n300#1:374,2\n300#1:376,4\n297#1:350,11\n302#1:380,11\n*E\n"})
    public static abstract class ExplainModuleAdviceAction
    implements WorkAction<ExplainModuleAdviceParams> {
        @NotNull
        private final Logger logger;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String module;
        @Nullable
        private final AndroidScore unfilteredAndroidScore;
        @Nullable
        private final AndroidScore finalAndroidScore;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainModuleAdviceAction() {
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            RegularFileProperty $this$filterIsInstance$iv;
            Object object;
            boolean $i$f$withNulls;
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl;
            BufferedSource reader$iv$iv$iv2;
            Iterable $this$fromJson$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
            this.logger = logger;
            Object object2 = ((ExplainModuleAdviceParams)this.getParameters()).getProjectPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.projectPath.get()");
            this.projectPath = (String)object2;
            Object object3 = ((ExplainModuleAdviceParams)this.getParameters()).getModule().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.module.get()");
            this.module = (String)object3;
            RegularFileProperty $i$f$getLogger22 = ((ExplainModuleAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            ExplainModuleAdviceAction explainModuleAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)closeable;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object5);
                object = object5;
            }
            catch (Throwable reader$iv$iv$iv2) {
                throwable = reader$iv$iv$iv2;
                throw reader$iv$iv$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)object).getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.unfilteredAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = ((ExplainModuleAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainModuleAdviceAction = this;
            $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get()");
            $this$fromJson$iv$iv = (RegularFile)object6;
            $i$f$fromJson = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson = false;
            element$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            throwable = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)element$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object7 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object7);
                object = object7;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(element$iv$iv2, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)object).getModuleAdvice();
            $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.finalAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        }

        public void execute() {
            this.validateModuleOption();
            String reason = new ModuleAdviceExplainer(new ProjectCoordinates(this.projectPath, GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), this.unfilteredAndroidScore, this.finalAndroidScore).computeReason();
            this.logger.quiet(reason);
        }

        private final void validateModuleOption() {
            if (!Intrinsics.areEqual((Object)this.module, (Object)"android")) {
                throw new InvalidUserDataException("'" + this.module + "' unexpected. The only valid option for '--module' at this time is 'android'.");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "finalAdviceReport", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalAdviceReport", "()Lorg/gradle/api/file/RegularFileProperty;", "module", "Lorg/gradle/api/provider/Property;", "", "getModule", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainModuleAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getModule();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Explainer;", "", "computeReason", "", "dependency-analysis-gradle-plugin"})
    public static interface Explainer {
        @NotNull
        public String computeReason();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Options;", "", "id", "", "module", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getModule", "dependency-analysis-gradle-plugin"})
    private static final class Options {
        @Nullable
        private final String id;
        @Nullable
        private final String module;

        public Options(@Nullable String id, @Nullable String module) {
            this.id = id;
            this.module = module;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getModule() {
            return this.module;
        }
    }
}

