/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.internal.ManifestParser;
import com.autonomousapps.internal.parse.ExplodedManifest;
import com.autonomousapps.model.internal.AndroidResSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u00130\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/internal/parse/AndroidManifestParser;", "", "manifests", "", "Ljava/io/File;", "projectDir", "namespace", "", "(Ljava/lang/Iterable;Ljava/io/File;Ljava/lang/String;)V", "explodedManifests", "", "Lcom/autonomousapps/internal/parse/ExplodedManifest;", "getExplodedManifests", "()Ljava/util/List;", "parser", "Lcom/autonomousapps/internal/ManifestParser;", "compute", "parseManifests", "toExplodedManifest", "Lkotlin/Pair;", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "toExplodedManifests", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nexplodeAndroidResSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidManifestParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n774#2:197\n865#2,2:198\n1557#2:200\n1628#2,3:201\n1557#2:204\n1628#2,3:205\n*S KotlinDebug\n*F\n+ 1 explodeAndroidResSource.kt\ncom/autonomousapps/internal/parse/AndroidManifestParser\n*L\n138#1:197\n138#1:198,2\n139#1:200\n139#1:201,3\n143#1:204\n143#1:205,3\n*E\n"})
public final class AndroidManifestParser {
    @NotNull
    private final Iterable<File> manifests;
    @NotNull
    private final File projectDir;
    @NotNull
    private final String namespace;
    @NotNull
    private final ManifestParser parser;
    @NotNull
    private final List<ExplodedManifest> explodedManifests;

    public AndroidManifestParser(@NotNull Iterable<? extends File> manifests, @NotNull File projectDir, @NotNull String namespace2) {
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        this.manifests = manifests;
        this.projectDir = projectDir;
        this.namespace = namespace2;
        this.parser = new ManifestParser(this.namespace);
        this.explodedManifests = this.compute();
    }

    @NotNull
    public final List<ExplodedManifest> getExplodedManifests() {
        return this.explodedManifests;
    }

    private final List<ExplodedManifest> compute() {
        String string;
        if (!StringsKt.isBlank((CharSequence)this.namespace)) {
            return this.parseManifests();
        }
        List parseResults = new ArrayList();
        List malformedManifests = new ArrayList();
        for (File manifest : this.manifests) {
            if (!manifest.exists()) continue;
            try {
                ((Collection)parseResults).add(TuplesKt.to((Object)manifest, (Object)ManifestParser.parse$default(this.parser, manifest, false, 2, null)));
            }
            catch (ManifestParser.ManifestParseException manifestParseException) {
                ((Collection)malformedManifests).add(manifest);
            }
        }
        Object object = (Pair)CollectionsKt.firstOrNull((List)parseResults);
        if ((object != null && (object = (ManifestParser.ParseResult)object.getSecond()) != null ? ((ManifestParser.ParseResult)object).getPackageName() : (string = null)) == null) {
            string = "";
        }
        String mainNamespace = string;
        ManifestParser malformedParser = new ManifestParser(mainNamespace);
        for (File remainder : malformedManifests) {
            ((Collection)parseResults).add(TuplesKt.to((Object)remainder, (Object)ManifestParser.parse$default(malformedParser, remainder, false, 2, null)));
        }
        return this.toExplodedManifests(parseResults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExplodedManifest> parseManifests() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<File> iterable = this.manifests;
        AndroidManifestParser androidManifestParser = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)ManifestParser.parse$default(this.parser, it, false, 2, null)));
        }
        return androidManifestParser.toExplodedManifests((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExplodedManifest> toExplodedManifests(Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$toExplodedManifests) {
        void $this$mapTo$iv$iv;
        Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> $this$map$iv = $this$toExplodedManifests;
        boolean $i$f$map = false;
        Iterable<? extends Pair<? extends File, ManifestParser.ParseResult>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toExplodedManifest((Pair<? extends File, ManifestParser.ParseResult>)it));
        }
        return (List)destination$iv$iv;
    }

    private final ExplodedManifest toExplodedManifest(Pair<? extends File, ManifestParser.ParseResult> $this$toExplodedManifest) {
        File file = (File)$this$toExplodedManifest.getFirst();
        ManifestParser.ParseResult parseResult = (ManifestParser.ParseResult)$this$toExplodedManifest.getSecond();
        String applicationName = parseResult.getApplicationName();
        AndroidResSource.AttrRef theme = AndroidResSource.AttrRef.Companion.style(parseResult.getTheme());
        return new ExplodedManifest(FilesKt.toRelativeString((File)file, (File)this.projectDir), applicationName, theme);
    }
}

