/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.parse;

import com.autonomousapps.model.internal.AndroidResSource;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/parse/AndroidResBuilder;", "", "relativePath", "", "(Ljava/lang/String;)V", "attrRefs", "", "Lcom/autonomousapps/model/internal/AndroidResSource$AttrRef;", "getAttrRefs", "()Ljava/util/Set;", "styleParentRefs", "Lcom/autonomousapps/model/internal/AndroidResSource$StyleParentRef;", "getStyleParentRefs", "usedClasses", "getUsedClasses", "build", "Lcom/autonomousapps/model/internal/AndroidResSource;", "concat", "other", "dependency-analysis-gradle-plugin"})
public final class AndroidResBuilder {
    @NotNull
    private final String relativePath;
    @NotNull
    private final Set<AndroidResSource.StyleParentRef> styleParentRefs;
    @NotNull
    private final Set<AndroidResSource.AttrRef> attrRefs;
    @NotNull
    private final Set<String> usedClasses;

    public AndroidResBuilder(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.relativePath = relativePath;
        this.styleParentRefs = new LinkedHashSet();
        this.attrRefs = new LinkedHashSet();
        this.usedClasses = new LinkedHashSet();
    }

    @NotNull
    public final Set<AndroidResSource.StyleParentRef> getStyleParentRefs() {
        return this.styleParentRefs;
    }

    @NotNull
    public final Set<AndroidResSource.AttrRef> getAttrRefs() {
        return this.attrRefs;
    }

    @NotNull
    public final Set<String> getUsedClasses() {
        return this.usedClasses;
    }

    @NotNull
    public final AndroidResBuilder concat(@NotNull AndroidResBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.styleParentRefs.addAll((Collection<AndroidResSource.StyleParentRef>)other.styleParentRefs);
        this.attrRefs.addAll((Collection<AndroidResSource.AttrRef>)other.attrRefs);
        this.usedClasses.addAll((Collection<String>)other.usedClasses);
        return this;
    }

    @NotNull
    public final AndroidResSource build() {
        return new AndroidResSource(this.relativePath, CollectionsKt.toSortedSet((Iterable)this.styleParentRefs), CollectionsKt.toSortedSet((Iterable)this.attrRefs), CollectionsKt.toSortedSet((Iterable)this.usedClasses));
    }
}

