/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.advice.ProjectHealthConsoleReportBuilder;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0007R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dslKind", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "postscript", "getPostscript", "projectAdvice", "getProjectAdvice", "action", "", "ProjectHealthAction", "ProjectHealthParameters", "dependency-analysis-gradle-plugin"})
public abstract class GenerateProjectHealthReportTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public GenerateProjectHealthReportTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setDescription("Generates console report for project health");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract Property<String> getPostscript();

    @Input
    @NotNull
    public abstract Property<DslKind> getDslKind();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(ProjectHealthAction.class, new Action(this){
            final /* synthetic */ GenerateProjectHealthReportTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProjectHealthParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getAdvice().set((Provider)this.this$0.getProjectAdvice());
                $this$submit.getPostscript().set((Provider)this.this$0.getPostscript());
                $this$submit.getDslKind().set((Provider)this.this$0.getDslKind());
                $this$submit.getDependencyMap().set((Provider)this.this$0.getDependencyMap());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nGenerateProjectHealthReportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateProjectHealthReportTask.kt\ncom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,83:1\n117#2,13:84\n41#3,2:97\n34#3,4:99\n*S KotlinDebug\n*F\n+ 1 GenerateProjectHealthReportTask.kt\ncom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthAction\n*L\n71#1:84,13\n71#1:97,2\n71#1:99,4\n*E\n"})
    public static abstract class ProjectHealthAction
    implements WorkAction<ProjectHealthParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object;
            File output = UtilsKt.getAndDelete(((ProjectHealthParameters)this.getParameters()).getOutput());
            RegularFileProperty $this$fromJson$iv = ((ProjectHealthParameters)this.getParameters()).getAdvice();
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object3 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
                Intrinsics.checkNotNull((Object)object3);
                object = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ProjectAdvice projectAdvice2 = (ProjectAdvice)object;
            Object object4 = ((ProjectHealthParameters)this.getParameters()).getPostscript().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.postscript.get()");
            String string = (String)object4;
            Object object5 = ((ProjectHealthParameters)this.getParameters()).getDslKind().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.dslKind.get()");
            DslKind dslKind = (DslKind)((Object)object5);
            Object object6 = ((ProjectHealthParameters)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.dependencyMap.get()");
            String consoleText = new ProjectHealthConsoleReportBuilder(projectAdvice2, string, dslKind, DependenciesHandler.Companion.toLambda((Map)object6)).getText();
            FilesKt.writeText$default((File)output, (String)consoleText, null, (int)2, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectHealthReportTask$ProjectHealthParameters;", "Lorg/gradle/workers/WorkParameters;", "advice", "Lorg/gradle/api/file/RegularFileProperty;", "getAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dslKind", "Lorg/gradle/api/provider/Property;", "Lcom/autonomousapps/internal/advice/DslKind;", "getDslKind", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "postscript", "getPostscript", "dependency-analysis-gradle-plugin"})
    public static interface ProjectHealthParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getAdvice();

        @NotNull
        public Property<String> getPostscript();

        @NotNull
        public Property<DslKind> getDslKind();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public RegularFileProperty getOutput();
    }
}

