/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.BuildServiceBuildersClient;
import com.azure.resourcemanager.appplatform.fluent.models.BuilderResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.DeploymentListInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.BuilderResourceCollection;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BuildServiceBuildersClientImpl
implements BuildServiceBuildersClient {
    private final BuildServiceBuildersService service;
    private final AppPlatformManagementClientImpl client;

    BuildServiceBuildersClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (BuildServiceBuildersService)RestProxy.create(BuildServiceBuildersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuilderResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuilderResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuilderResourceInner> getAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuilderResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuilderResourceInner> getWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuilderResourceInner get(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return (BuilderResourceInner)((Object)this.getWithResponse(resourceGroupName, serviceName, buildServiceName, builderName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (builderResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderResource is required and cannot be null."));
        }
        builderResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, builderResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (builderResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderResource is required and cannot be null."));
        }
        builderResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, builderResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuilderResourceInner.class), (Type)((Object)BuilderResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuilderResourceInner.class), (Type)((Object)BuilderResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuilderResourceInner>, BuilderResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuilderResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BuilderResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuilderResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource) {
        return (BuilderResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuilderResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, BuilderResourceInner builderResource, Context context) {
        return (BuilderResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, builderResource, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        this.deleteAsync(resourceGroupName, serviceName, buildServiceName, builderName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuilderResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuilderResourceCollection)res.getValue()).value(), ((BuilderResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuilderResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuilderResourceCollection)res.getValue()).value(), ((BuilderResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuilderResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuilderResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuilderResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, buildServiceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuilderResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, buildServiceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentListInner>> listDeploymentsWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeployments(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentListInner>> listDeploymentsWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeployments(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentListInner> listDeploymentsAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return this.listDeploymentsWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName).flatMap(res -> Mono.justOrEmpty((Object)((DeploymentListInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentListInner> listDeploymentsWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return (Response)this.listDeploymentsWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentListInner listDeployments(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return (DeploymentListInner)this.listDeploymentsWithResponse(resourceGroupName, serviceName, buildServiceName, builderName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuilderResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuilderResourceCollection)res.getValue()).value(), ((BuilderResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuilderResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuilderResourceCollection)res.getValue()).value(), ((BuilderResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface BuildServiceBuildersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuilderResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @BodyParam(value="application/json") BuilderResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuilderResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/listUsingDeployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListInner>> listDeployments(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuilderResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

