/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGeneration;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceInstance;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceProvisioningState;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceResourceRequests;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ConfigurationServiceProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ConfigurationServiceProvisioningState provisioningState;
    @JsonProperty(value="generation")
    private ConfigurationServiceGeneration generation;
    @JsonProperty(value="resourceRequests", access=JsonProperty.Access.WRITE_ONLY)
    private ConfigurationServiceResourceRequests resourceRequests;
    @JsonProperty(value="instances", access=JsonProperty.Access.WRITE_ONLY)
    private List<ConfigurationServiceInstance> instances;
    @JsonProperty(value="settings")
    private ConfigurationServiceSettings settings;

    public ConfigurationServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ConfigurationServiceGeneration generation() {
        return this.generation;
    }

    public ConfigurationServiceProperties withGeneration(ConfigurationServiceGeneration generation) {
        this.generation = generation;
        return this;
    }

    public ConfigurationServiceResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<ConfigurationServiceInstance> instances() {
        return this.instances;
    }

    public ConfigurationServiceSettings settings() {
        return this.settings;
    }

    public ConfigurationServiceProperties withSettings(ConfigurationServiceSettings settings) {
        this.settings = settings;
        return this;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
    }
}

