/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ApplicationLiveViewInstance;
import com.azure.resourcemanager.appplatform.models.ApplicationLiveViewResourceRequests;
import java.io.IOException;
import java.util.List;

public final class ApplicationLiveViewComponent
implements JsonSerializable<ApplicationLiveViewComponent> {
    private Object name;
    private ApplicationLiveViewResourceRequests resourceRequests;
    private List<ApplicationLiveViewInstance> instances;

    public Object name() {
        return this.name;
    }

    public ApplicationLiveViewResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public List<ApplicationLiveViewInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApplicationLiveViewComponent fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationLiveViewComponent)jsonReader.readObject(reader -> {
            ApplicationLiveViewComponent deserializedApplicationLiveViewComponent = new ApplicationLiveViewComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationLiveViewComponent.name = reader.readUntyped();
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedApplicationLiveViewComponent.resourceRequests = ApplicationLiveViewResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedApplicationLiveViewComponent.instances = instances = reader.readArray(reader1 -> ApplicationLiveViewInstance.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationLiveViewComponent;
        });
    }
}

