/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AcceleratorGitRepository;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorProvisioningState;
import com.azure.resourcemanager.appplatform.models.CustomizedAcceleratorType;
import java.io.IOException;
import java.util.List;

public final class CustomizedAcceleratorProperties
implements JsonSerializable<CustomizedAcceleratorProperties> {
    private CustomizedAcceleratorProvisioningState provisioningState;
    private CustomizedAcceleratorType acceleratorType;
    private String displayName;
    private String description;
    private String iconUrl;
    private List<String> acceleratorTags;
    private List<String> imports;
    private AcceleratorGitRepository gitRepository;
    private static final ClientLogger LOGGER = new ClientLogger(CustomizedAcceleratorProperties.class);

    public CustomizedAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CustomizedAcceleratorType acceleratorType() {
        return this.acceleratorType;
    }

    public CustomizedAcceleratorProperties withAcceleratorType(CustomizedAcceleratorType acceleratorType) {
        this.acceleratorType = acceleratorType;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public CustomizedAcceleratorProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public CustomizedAcceleratorProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public CustomizedAcceleratorProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public List<String> acceleratorTags() {
        return this.acceleratorTags;
    }

    public CustomizedAcceleratorProperties withAcceleratorTags(List<String> acceleratorTags) {
        this.acceleratorTags = acceleratorTags;
        return this;
    }

    public List<String> imports() {
        return this.imports;
    }

    public AcceleratorGitRepository gitRepository() {
        return this.gitRepository;
    }

    public CustomizedAcceleratorProperties withGitRepository(AcceleratorGitRepository gitRepository) {
        this.gitRepository = gitRepository;
        return this;
    }

    public void validate() {
        if (this.gitRepository() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property gitRepository in model CustomizedAcceleratorProperties"));
        }
        this.gitRepository().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gitRepository", (JsonSerializable)this.gitRepository);
        jsonWriter.writeStringField("acceleratorType", this.acceleratorType == null ? null : this.acceleratorType.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("iconUrl", this.iconUrl);
        jsonWriter.writeArrayField("acceleratorTags", this.acceleratorTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CustomizedAcceleratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CustomizedAcceleratorProperties)jsonReader.readObject(reader -> {
            CustomizedAcceleratorProperties deserializedCustomizedAcceleratorProperties = new CustomizedAcceleratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("gitRepository".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.gitRepository = AcceleratorGitRepository.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.provisioningState = CustomizedAcceleratorProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("acceleratorType".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.acceleratorType = CustomizedAcceleratorType.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.description = reader.getString();
                    continue;
                }
                if ("iconUrl".equals(fieldName)) {
                    deserializedCustomizedAcceleratorProperties.iconUrl = reader.getString();
                    continue;
                }
                if ("acceleratorTags".equals(fieldName)) {
                    List acceleratorTags;
                    deserializedCustomizedAcceleratorProperties.acceleratorTags = acceleratorTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("imports".equals(fieldName)) {
                    List imports;
                    deserializedCustomizedAcceleratorProperties.imports = imports = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomizedAcceleratorProperties;
        });
    }
}

