/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceProperties;
import com.azure.resourcemanager.appplatform.models.Sku;
import java.io.IOException;

public final class DeploymentResourceInner
extends ProxyResource {
    private DeploymentResourceProperties properties;
    private Sku sku;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public DeploymentResourceProperties properties() {
        return this.properties;
    }

    public DeploymentResourceInner withProperties(DeploymentResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public DeploymentResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentResourceInner)((Object)jsonReader.readObject(reader -> {
            DeploymentResourceInner deserializedDeploymentResourceInner = new DeploymentResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeploymentResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeploymentResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentResourceInner.properties = DeploymentResourceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDeploymentResourceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDeploymentResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentResourceInner;
        }));
    }
}

