/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.PredefinedAcceleratorsClient;
import com.azure.resourcemanager.appplatform.fluent.models.PredefinedAcceleratorResourceInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.PredefinedAcceleratorResourceCollection;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PredefinedAcceleratorsClientImpl
implements PredefinedAcceleratorsClient {
    private final PredefinedAcceleratorsService service;
    private final AppPlatformManagementClientImpl client;

    PredefinedAcceleratorsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (PredefinedAcceleratorsService)RestProxy.create(PredefinedAcceleratorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PredefinedAcceleratorResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PredefinedAcceleratorResourceCollection)res.getValue()).value(), ((PredefinedAcceleratorResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PredefinedAcceleratorResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PredefinedAcceleratorResourceCollection)res.getValue()).value(), ((PredefinedAcceleratorResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PredefinedAcceleratorResourceInner> listAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, applicationAcceleratorName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PredefinedAcceleratorResourceInner> listAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, applicationAcceleratorName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PredefinedAcceleratorResourceInner> list(String resourceGroupName, String serviceName, String applicationAcceleratorName) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, applicationAcceleratorName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PredefinedAcceleratorResourceInner> list(String resourceGroupName, String serviceName, String applicationAcceleratorName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, applicationAcceleratorName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PredefinedAcceleratorResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PredefinedAcceleratorResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PredefinedAcceleratorResourceInner> getAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PredefinedAcceleratorResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PredefinedAcceleratorResourceInner> getWithResponse(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PredefinedAcceleratorResourceInner get(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return (PredefinedAcceleratorResourceInner)((Object)this.getWithResponse(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> disableWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disable(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disable(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDisableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDisableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return this.beginDisableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        return this.beginDisableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return this.beginDisableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> disableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        return this.beginDisableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        this.disableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        this.disableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> enableWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enable(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableWithResponseAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (applicationAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationAcceleratorName is required and cannot be null."));
        }
        if (predefinedAcceleratorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter predefinedAcceleratorName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enable(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginEnableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableWithResponseAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return this.beginEnableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        return this.beginEnableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        return this.beginEnableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> enableAsync(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        return this.beginEnableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName) {
        this.enableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enable(String resourceGroupName, String serviceName, String applicationAcceleratorName, String predefinedAcceleratorName, Context context) {
        this.enableAsync(resourceGroupName, serviceName, applicationAcceleratorName, predefinedAcceleratorName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PredefinedAcceleratorResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PredefinedAcceleratorResourceCollection)res.getValue()).value(), ((PredefinedAcceleratorResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PredefinedAcceleratorResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PredefinedAcceleratorResourceCollection)res.getValue()).value(), ((PredefinedAcceleratorResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface PredefinedAcceleratorsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/predefinedAccelerators")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PredefinedAcceleratorResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationAcceleratorName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/predefinedAccelerators/{predefinedAcceleratorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PredefinedAcceleratorResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationAcceleratorName") String var6, @PathParam(value="predefinedAcceleratorName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/predefinedAccelerators/{predefinedAcceleratorName}/disable")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> disable(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationAcceleratorName") String var6, @PathParam(value="predefinedAcceleratorName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/predefinedAccelerators/{predefinedAcceleratorName}/enable")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> enable(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="applicationAcceleratorName") String var6, @PathParam(value="predefinedAcceleratorName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PredefinedAcceleratorResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

