/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AcceleratorAuthSetting;
import java.io.IOException;

public final class AcceleratorBasicAuthSetting
extends AcceleratorAuthSetting {
    private String authType = "BasicAuth";
    private String caCertResourceId;
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorBasicAuthSetting.class);

    @Override
    public String authType() {
        return this.authType;
    }

    public String caCertResourceId() {
        return this.caCertResourceId;
    }

    public AcceleratorBasicAuthSetting withCaCertResourceId(String caCertResourceId) {
        this.caCertResourceId = caCertResourceId;
        return this;
    }

    public String username() {
        return this.username;
    }

    public AcceleratorBasicAuthSetting withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public AcceleratorBasicAuthSetting withPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model AcceleratorBasicAuthSetting"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("authType", this.authType);
        jsonWriter.writeStringField("caCertResourceId", this.caCertResourceId);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static AcceleratorBasicAuthSetting fromJson(JsonReader jsonReader) throws IOException {
        return (AcceleratorBasicAuthSetting)jsonReader.readObject(reader -> {
            AcceleratorBasicAuthSetting deserializedAcceleratorBasicAuthSetting = new AcceleratorBasicAuthSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.username = reader.getString();
                    continue;
                }
                if ("authType".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.authType = reader.getString();
                    continue;
                }
                if ("caCertResourceId".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.caCertResourceId = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAcceleratorBasicAuthSetting.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcceleratorBasicAuthSetting;
        });
    }
}

