/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ApplicationAcceleratorInstance;
import com.azure.resourcemanager.appplatform.models.ApplicationAcceleratorResourceRequests;
import java.io.IOException;
import java.util.List;

public final class ApplicationAcceleratorComponent
implements JsonSerializable<ApplicationAcceleratorComponent> {
    private String name;
    private ApplicationAcceleratorResourceRequests resourceRequests;
    private List<ApplicationAcceleratorInstance> instances;

    public String name() {
        return this.name;
    }

    public ApplicationAcceleratorResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public ApplicationAcceleratorComponent withResourceRequests(ApplicationAcceleratorResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public List<ApplicationAcceleratorInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceRequests", (JsonSerializable)this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationAcceleratorComponent fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationAcceleratorComponent)jsonReader.readObject(reader -> {
            ApplicationAcceleratorComponent deserializedApplicationAcceleratorComponent = new ApplicationAcceleratorComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationAcceleratorComponent.name = reader.getString();
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedApplicationAcceleratorComponent.resourceRequests = ApplicationAcceleratorResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedApplicationAcceleratorComponent.instances = instances = reader.readArray(reader1 -> ApplicationAcceleratorInstance.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationAcceleratorComponent;
        });
    }
}

