/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ProbeAction;
import java.io.IOException;

public final class Probe
implements JsonSerializable<Probe> {
    private ProbeAction probeAction;
    private boolean disableProbe;
    private Integer initialDelaySeconds;
    private Integer periodSeconds;
    private Integer timeoutSeconds;
    private Integer failureThreshold;
    private Integer successThreshold;

    public ProbeAction probeAction() {
        return this.probeAction;
    }

    public Probe withProbeAction(ProbeAction probeAction) {
        this.probeAction = probeAction;
        return this;
    }

    public boolean disableProbe() {
        return this.disableProbe;
    }

    public Probe withDisableProbe(boolean disableProbe) {
        this.disableProbe = disableProbe;
        return this;
    }

    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public Probe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    public Probe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Probe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public Probe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Integer successThreshold() {
        return this.successThreshold;
    }

    public Probe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    public void validate() {
        if (this.probeAction() != null) {
            this.probeAction().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("disableProbe", this.disableProbe);
        jsonWriter.writeJsonField("probeAction", (JsonSerializable)this.probeAction);
        jsonWriter.writeNumberField("initialDelaySeconds", (Number)this.initialDelaySeconds);
        jsonWriter.writeNumberField("periodSeconds", (Number)this.periodSeconds);
        jsonWriter.writeNumberField("timeoutSeconds", (Number)this.timeoutSeconds);
        jsonWriter.writeNumberField("failureThreshold", (Number)this.failureThreshold);
        jsonWriter.writeNumberField("successThreshold", (Number)this.successThreshold);
        return jsonWriter.writeEndObject();
    }

    public static Probe fromJson(JsonReader jsonReader) throws IOException {
        return (Probe)jsonReader.readObject(reader -> {
            Probe deserializedProbe = new Probe();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("disableProbe".equals(fieldName)) {
                    deserializedProbe.disableProbe = reader.getBoolean();
                    continue;
                }
                if ("probeAction".equals(fieldName)) {
                    deserializedProbe.probeAction = ProbeAction.fromJson(reader);
                    continue;
                }
                if ("initialDelaySeconds".equals(fieldName)) {
                    deserializedProbe.initialDelaySeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("periodSeconds".equals(fieldName)) {
                    deserializedProbe.periodSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeoutSeconds".equals(fieldName)) {
                    deserializedProbe.timeoutSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failureThreshold".equals(fieldName)) {
                    deserializedProbe.failureThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("successThreshold".equals(fieldName)) {
                    deserializedProbe.successThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProbe;
        });
    }
}

