/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class SiteContainerProperties {
    @JsonProperty(value="image", required=true)
    private String image;
    @JsonProperty(value="targetPort")
    private String targetPort;
    @JsonProperty(value="isMain", required=true)
    private boolean isMain;
    @JsonProperty(value="startUpCommand")
    private String startUpCommand;
    @JsonProperty(value="authType")
    private AuthType authType;
    @JsonProperty(value="userName")
    private String username;
    @JsonProperty(value="passwordSecret")
    private String passwordSecret;
    @JsonProperty(value="userManagedIdentityClientId")
    private String userManagedIdentityClientId;
    @JsonProperty(value="createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="volumeMounts")
    private List<VolumeMount> volumeMounts;
    @JsonProperty(value="environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    private static final ClientLogger LOGGER = new ClientLogger(SiteContainerProperties.class);

    public String image() {
        return this.image;
    }

    public SiteContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    public String targetPort() {
        return this.targetPort;
    }

    public SiteContainerProperties withTargetPort(String targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public SiteContainerProperties withIsMain(boolean isMain) {
        this.isMain = isMain;
        return this;
    }

    public String startUpCommand() {
        return this.startUpCommand;
    }

    public SiteContainerProperties withStartUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
        return this;
    }

    public AuthType authType() {
        return this.authType;
    }

    public SiteContainerProperties withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SiteContainerProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public String passwordSecret() {
        return this.passwordSecret;
    }

    public SiteContainerProperties withPasswordSecret(String passwordSecret) {
        this.passwordSecret = passwordSecret;
        return this;
    }

    public String userManagedIdentityClientId() {
        return this.userManagedIdentityClientId;
    }

    public SiteContainerProperties withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        this.userManagedIdentityClientId = userManagedIdentityClientId;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public SiteContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public SiteContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public void validate() {
        if (this.image() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property image in model SiteContainerProperties"));
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
    }
}

