/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentInner;
import com.azure.resourcemanager.appservice.fluent.models.ValidatePropertiesInner;
import com.azure.resourcemanager.appservice.models.ValidateResourceTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ValidateRequestInner {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private ValidateResourceTypes type;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties", required=true)
    private ValidatePropertiesInner innerProperties = new ValidatePropertiesInner();
    private static final ClientLogger LOGGER = new ClientLogger(ValidateRequestInner.class);

    public String name() {
        return this.name;
    }

    public ValidateRequestInner withName(String name) {
        this.name = name;
        return this;
    }

    public ValidateResourceTypes type() {
        return this.type;
    }

    public ValidateRequestInner withType(ValidateResourceTypes type) {
        this.type = type;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ValidateRequestInner withLocation(String location) {
        this.location = location;
        return this;
    }

    private ValidatePropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public ValidateRequestInner withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public String skuName() {
        return this.innerProperties() == null ? null : this.innerProperties().skuName();
    }

    public ValidateRequestInner withSkuName(String skuName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withSkuName(skuName);
        return this;
    }

    public Boolean needLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().needLinuxWorkers();
    }

    public ValidateRequestInner withNeedLinuxWorkers(Boolean needLinuxWorkers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withNeedLinuxWorkers(needLinuxWorkers);
        return this;
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public ValidateRequestInner withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public Integer capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public ValidateRequestInner withCapacity(Integer capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    public String hostingEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironment();
    }

    public ValidateRequestInner withHostingEnvironment(String hostingEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withHostingEnvironment(hostingEnvironment);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public ValidateRequestInner withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public String containerRegistryBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryBaseUrl();
    }

    public ValidateRequestInner withContainerRegistryBaseUrl(String containerRegistryBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryBaseUrl(containerRegistryBaseUrl);
        return this;
    }

    public String containerRegistryUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryUsername();
    }

    public ValidateRequestInner withContainerRegistryUsername(String containerRegistryUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryUsername(containerRegistryUsername);
        return this;
    }

    public String containerRegistryPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryPassword();
    }

    public ValidateRequestInner withContainerRegistryPassword(String containerRegistryPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryPassword(containerRegistryPassword);
        return this;
    }

    public String containerImageRepository() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageRepository();
    }

    public ValidateRequestInner withContainerImageRepository(String containerImageRepository) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImageRepository(containerImageRepository);
        return this;
    }

    public String containerImageTag() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageTag();
    }

    public ValidateRequestInner withContainerImageTag(String containerImageTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImageTag(containerImageTag);
        return this;
    }

    public String containerImagePlatform() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImagePlatform();
    }

    public ValidateRequestInner withContainerImagePlatform(String containerImagePlatform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImagePlatform(containerImagePlatform);
        return this;
    }

    public AppServiceEnvironmentInner appServiceEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().appServiceEnvironment();
    }

    public ValidateRequestInner withAppServiceEnvironment(AppServiceEnvironmentInner appServiceEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withAppServiceEnvironment(appServiceEnvironment);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ValidateRequestInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ValidateRequestInner"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ValidateRequestInner"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ValidateRequestInner"));
        }
        this.innerProperties().validate();
    }
}

