/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.TopLevelDomainProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class TopLevelDomainInner
extends ProxyOnlyResource {
    private TopLevelDomainProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private TopLevelDomainProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public TopLevelDomainInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Boolean privacy() {
        return this.innerProperties() == null ? null : this.innerProperties().privacy();
    }

    public TopLevelDomainInner withPrivacy(Boolean privacy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopLevelDomainProperties();
        }
        this.innerProperties().withPrivacy(privacy);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TopLevelDomainInner fromJson(JsonReader jsonReader) throws IOException {
        return (TopLevelDomainInner)((Object)jsonReader.readObject(reader -> {
            TopLevelDomainInner deserializedTopLevelDomainInner = new TopLevelDomainInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTopLevelDomainInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTopLevelDomainInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTopLevelDomainInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedTopLevelDomainInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTopLevelDomainInner.innerProperties = TopLevelDomainProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopLevelDomainInner;
        }));
    }
}

