/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

class KuduClient {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final String host;
    private final KuduService service;
    private static final String DEPLOYER_JAVA_SDK = "JavaSDK";
    private static final Duration MAX_DEPLOY_TIMEOUT = Duration.ofMinutes(10L);

    KuduClient(WebAppBase webAppBase) {
        if (webAppBase.defaultHostname() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot initialize kudu client before web app is created"));
        }
        String host = webAppBase.defaultHostname().toLowerCase(Locale.ROOT).replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = parts[0] + ".scm." + parts[1];
        this.host = "https://" + host;
        this.service = (KuduService)RestProxy.create(KuduService.class, (HttpPipeline)((AppServiceManager)((Object)webAppBase.manager())).httpPipeline(), (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
    }

    Flux<String> streamApplicationLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamApplicationLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamHttpLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamHttpLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamTraceLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamTraceLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamDeploymentLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamDeploymentLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamAllLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamAllLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    static Flux<String> streamFromFluxBytes(Flux<ByteBuffer> source) {
        int newLine = 10;
        int newLineR = 13;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        return source.concatMap(byteBuffer -> {
            int index = KuduClient.findByte(byteBuffer, (byte)10);
            if (index == -1) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                    return Flux.empty();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            while ((index = KuduClient.findByte(byteBuffer, (byte)10)) != -1) {
                byte[] byteArray = new byte[index + 1];
                byteBuffer.get(byteArray);
                try {
                    stream.write(byteArray);
                    String line = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                    if (line.isEmpty() || line.charAt(line.length() - 1) != '\n') continue;
                    if (!(line = line.substring(0, line.length() - 1)).isEmpty() && line.charAt(line.length() - 1) == '\r') {
                        line = line.substring(0, line.length() - 1);
                    }
                    lines.add(line);
                    stream.reset();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (byteBuffer.hasRemaining()) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (lines.isEmpty()) {
                return Flux.empty();
            }
            return Flux.fromIterable(lines);
        });
    }

    private static int findByte(ByteBuffer byteBuffer, byte b) {
        int position = byteBuffer.position();
        int index = -1;
        for (int i = 0; i < byteBuffer.remaining(); ++i) {
            if (byteBuffer.get(position + i) != b) continue;
            index = i;
            break;
        }
        return index;
    }

    Mono<Void> warDeployAsync(InputStream warFile, long length, String appName) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)warFile);
        return this.retryOnError(this.service.warDeploy(this.host, (Flux<ByteBuffer>)flux, length, appName));
    }

    Mono<Void> warDeployAsync(File warFile, String appName) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(warFile.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.warDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), appName)).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)zipFile);
        return this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)flux, length, false, null)).then();
    }

    Mono<Void> zipDeployAsync(File zipFile) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(zipFile.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), false, null)).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        }).then();
    }

    Mono<Void> deployAsync(DeployType type, InputStream file, long length, String path, Boolean restart, Boolean clean) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)file);
        return this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)flux, length, type, path, restart, clean, false, false)).then();
    }

    Mono<Void> deployAsync(DeployType type, File file, String path, Boolean restart, Boolean clean) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), type, path, restart, clean, false, false)).then().doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, File file, String path, Boolean restart, Boolean clean, Boolean trackDeployment) throws IOException {
        boolean trackDeploymentProgress = trackDeployment == null || trackDeployment != false;
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.getDeploymentResult(this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), type, path, restart, clean, true, trackDeployment)), trackDeploymentProgress).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    private Mono<KuduDeploymentResult> getDeploymentResult(Mono<Response<Void>> responseMono, boolean trackDeploymentProgress) {
        return responseMono.map(response -> {
            HttpHeader deploymentIdHeader = response.getHeaders().get("SCM-DEPLOYMENT-ID");
            if (trackDeploymentProgress && (deploymentIdHeader == null || deploymentIdHeader.getValue() == null || deploymentIdHeader.getValue().isEmpty())) {
                throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Deployment ID not found in response header 'SCM-DEPLOYMENT-ID'"));
            }
            return new KuduDeploymentResult(deploymentIdHeader == null ? null : deploymentIdHeader.getValue());
        });
    }

    Mono<KuduDeploymentResult> pushZipDeployAsync(File file) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.getDeploymentResult(this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), true, DEPLOYER_JAVA_SDK)), true).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<KuduDeploymentResult> pushZipDeployAsync(InputStream file, long length) throws IOException {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)file);
        return this.getDeploymentResult(this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)flux, length, true, DEPLOYER_JAVA_SDK)), true);
    }

    Mono<KuduDeploymentResult> pushDeployFlexConsumptionAsync(File file) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.deployFlexConsumption(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), false, DEPLOYER_JAVA_SDK)).then(Mono.just((Object)new KuduDeploymentResult("latest"))).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<KuduDeploymentResult> pushDeployFlexConsumptionAsync(InputStream file, long length) throws IOException {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)file);
        return this.retryOnError(this.service.deployFlexConsumption(this.host, (Flux<ByteBuffer>)flux, length, false, DEPLOYER_JAVA_SDK)).then(Mono.just((Object)new KuduDeploymentResult("latest")));
    }

    Mono<Map<String, String>> settings() {
        return this.retryOnError(this.service.settings(this.host));
    }

    Mono<Void> pollDeploymentStatus(KuduDeploymentResult result, Duration pollInterval) {
        AtomicLong pollCount = new AtomicLong();
        AtomicReference<String> deploymentId = new AtomicReference<String>(result.deploymentId());
        return Mono.defer(() -> this.service.deploymentStatus(this.host, (String)deploymentId.get())).flatMap(response -> {
            DeploymentStatus deploymentStatus = (DeploymentStatus)response.getValue();
            Integer status = deploymentStatus.getStatus();
            boolean succeeded = status == 4;
            boolean completed = succeeded || status == -1 || status >= 3 && status <= 6;
            String id = deploymentStatus.getId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)id) && deploymentStatus.getTemp() == Boolean.FALSE) {
                deploymentId.set(id);
            }
            if (succeeded) {
                return Mono.just((Object)deploymentStatus);
            }
            if (completed) {
                return Mono.error((Throwable)new RuntimeException("Deployment failed, status " + status));
            }
            if (pollInterval.multipliedBy(pollCount.get()).compareTo(MAX_DEPLOY_TIMEOUT) >= 0) {
                return Mono.error((Throwable)new RuntimeException("Deployment timed out, status " + status));
            }
            return Mono.empty();
        }).repeatWhenEmpty(longFlux -> longFlux.flatMap(index -> {
            pollCount.set((long)index);
            return Mono.delay((Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)pollInterval));
        })).then();
    }

    private <T> Mono<T> retryOnError(Mono<T> observable) {
        int retryCount = 6;
        return observable.retryWhen(Retry.withThrowable(flux -> flux.zipWith((Publisher)Flux.range((int)1, (int)6), (throwable, count) -> {
            if (count < 6 && (throwable instanceof TimeoutException || throwable instanceof SocketTimeoutException)) {
                return count;
            }
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)throwable));
        }).flatMap(i -> Mono.delay((Duration)Duration.ofSeconds((long)i.intValue() * 10L)))));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KuduService")
    private static interface KuduService {
        @Get(value="api/logstream/application")
        public Mono<StreamResponse> streamApplicationLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/http")
        public Mono<StreamResponse> streamHttpLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/kudu/trace")
        public Mono<StreamResponse> streamTraceLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/kudu/deployment")
        public Mono<StreamResponse> streamDeploymentLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream")
        public Mono<StreamResponse> streamAllLogs(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/wardeploy")
        public Mono<Void> warDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="name") String var5);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/zipdeploy")
        public Mono<Response<Void>> zipDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="isAsync") Boolean var5, @QueryParam(value="deployer") String var6);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/publish")
        public Mono<Response<Void>> deploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="type") DeployType var5, @QueryParam(value="path") String var6, @QueryParam(value="restart") Boolean var7, @QueryParam(value="clean") Boolean var8, @QueryParam(value="isAsync") Boolean var9, @QueryParam(value="trackDeploymentProgress") Boolean var10);

        @Headers(value={"Content-Type: application/zip"})
        @Post(value="api/publish")
        public Mono<Response<Void>> deployFlexConsumption(@HostParam(value="$host") String var1, @BodyParam(value="application/zip") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="remoteBuild") Boolean var5, @QueryParam(value="deployer") String var6);

        @Get(value="api/settings")
        public Mono<Map<String, String>> settings(@HostParam(value="$host") String var1);

        @Headers(value={"Accept: application/json"})
        @Get(value="api/deployments/{deploymentId}")
        public Mono<Response<DeploymentStatus>> deploymentStatus(@HostParam(value="$host") String var1, @PathParam(value="deploymentId") String var2);
    }

    public static class DeploymentStatus
    implements JsonSerializable<DeploymentStatus> {
        private String id;
        private Integer status;
        private Boolean isTemp;

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            jsonWriter.writeStartObject();
            return jsonWriter.writeEndObject();
        }

        public static DeploymentStatus fromJson(JsonReader jsonReader) throws IOException {
            return (DeploymentStatus)jsonReader.readObject(reader -> {
                DeploymentStatus deserializedDeploymentStatus = new DeploymentStatus();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("id".equals(fieldName)) {
                        deserializedDeploymentStatus.id = reader.getString();
                        continue;
                    }
                    if ("status".equals(fieldName)) {
                        deserializedDeploymentStatus.status = (Integer)reader.getNullable(JsonReader::getInt);
                        continue;
                    }
                    if ("is_temp".equals(fieldName)) {
                        deserializedDeploymentStatus.isTemp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                        continue;
                    }
                    reader.skipChildren();
                }
                return deserializedDeploymentStatus;
            });
        }

        public String getId() {
            return this.id;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Boolean getTemp() {
            return this.isTemp;
        }
    }
}

