/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanPatchResourceProperties;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StatusOptions;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AppServicePlanPatchResource
extends ProxyOnlyResource {
    private AppServicePlanPatchResourceProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private AppServicePlanPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AppServicePlanPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String workerTierName() {
        return this.innerProperties() == null ? null : this.innerProperties().workerTierName();
    }

    public AppServicePlanPatchResource withWorkerTierName(String workerTierName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withWorkerTierName(workerTierName);
        return this;
    }

    public StatusOptions status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public AppServicePlanPatchResource withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withHostingEnvironmentProfile(hostingEnvironmentProfile);
        return this;
    }

    public Integer maximumNumberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfWorkers();
    }

    public Integer numberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfWorkers();
    }

    public String geoRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().geoRegion();
    }

    public Boolean perSiteScaling() {
        return this.innerProperties() == null ? null : this.innerProperties().perSiteScaling();
    }

    public AppServicePlanPatchResource withPerSiteScaling(Boolean perSiteScaling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withPerSiteScaling(perSiteScaling);
        return this;
    }

    public Boolean elasticScaleEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticScaleEnabled();
    }

    public AppServicePlanPatchResource withElasticScaleEnabled(Boolean elasticScaleEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withElasticScaleEnabled(elasticScaleEnabled);
        return this;
    }

    public Integer maximumElasticWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumElasticWorkerCount();
    }

    public AppServicePlanPatchResource withMaximumElasticWorkerCount(Integer maximumElasticWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withMaximumElasticWorkerCount(maximumElasticWorkerCount);
        return this;
    }

    public Integer numberOfSites() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfSites();
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public AppServicePlanPatchResource withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public OffsetDateTime spotExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().spotExpirationTime();
    }

    public AppServicePlanPatchResource withSpotExpirationTime(OffsetDateTime spotExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withSpotExpirationTime(spotExpirationTime);
        return this;
    }

    public OffsetDateTime freeOfferExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().freeOfferExpirationTime();
    }

    public AppServicePlanPatchResource withFreeOfferExpirationTime(OffsetDateTime freeOfferExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withFreeOfferExpirationTime(freeOfferExpirationTime);
        return this;
    }

    public String resourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGroup();
    }

    public Boolean reserved() {
        return this.innerProperties() == null ? null : this.innerProperties().reserved();
    }

    public AppServicePlanPatchResource withReserved(Boolean reserved) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withReserved(reserved);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public AppServicePlanPatchResource withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public Boolean hyperV() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperV();
    }

    public AppServicePlanPatchResource withHyperV(Boolean hyperV) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withHyperV(hyperV);
        return this;
    }

    public Integer targetWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerCount();
    }

    public AppServicePlanPatchResource withTargetWorkerCount(Integer targetWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withTargetWorkerCount(targetWorkerCount);
        return this;
    }

    public Integer targetWorkerSizeId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerSizeId();
    }

    public AppServicePlanPatchResource withTargetWorkerSizeId(Integer targetWorkerSizeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withTargetWorkerSizeId(targetWorkerSizeId);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public KubeEnvironmentProfile kubeEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeEnvironmentProfile();
    }

    public AppServicePlanPatchResource withKubeEnvironmentProfile(KubeEnvironmentProfile kubeEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withKubeEnvironmentProfile(kubeEnvironmentProfile);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServicePlanPatchResource withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanPatchResourceProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AppServicePlanPatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (AppServicePlanPatchResource)((Object)jsonReader.readObject(reader -> {
            AppServicePlanPatchResource deserializedAppServicePlanPatchResource = new AppServicePlanPatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServicePlanPatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServicePlanPatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServicePlanPatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServicePlanPatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServicePlanPatchResource.innerProperties = AppServicePlanPatchResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServicePlanPatchResource;
        }));
    }
}

