/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FrequencyUnit;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BackupSchedule
implements JsonSerializable<BackupSchedule> {
    private int frequencyInterval;
    private FrequencyUnit frequencyUnit;
    private boolean keepAtLeastOneBackup;
    private int retentionPeriodInDays;
    private OffsetDateTime startTime;
    private OffsetDateTime lastExecutionTime;
    private static final ClientLogger LOGGER = new ClientLogger(BackupSchedule.class);

    public int frequencyInterval() {
        return this.frequencyInterval;
    }

    public BackupSchedule withFrequencyInterval(int frequencyInterval) {
        this.frequencyInterval = frequencyInterval;
        return this;
    }

    public FrequencyUnit frequencyUnit() {
        return this.frequencyUnit;
    }

    public BackupSchedule withFrequencyUnit(FrequencyUnit frequencyUnit) {
        this.frequencyUnit = frequencyUnit;
        return this;
    }

    public boolean keepAtLeastOneBackup() {
        return this.keepAtLeastOneBackup;
    }

    public BackupSchedule withKeepAtLeastOneBackup(boolean keepAtLeastOneBackup) {
        this.keepAtLeastOneBackup = keepAtLeastOneBackup;
        return this;
    }

    public int retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public BackupSchedule withRetentionPeriodInDays(int retentionPeriodInDays) {
        this.retentionPeriodInDays = retentionPeriodInDays;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public BackupSchedule withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime lastExecutionTime() {
        return this.lastExecutionTime;
    }

    public void validate() {
        if (this.frequencyUnit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frequencyUnit in model BackupSchedule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("frequencyInterval", this.frequencyInterval);
        jsonWriter.writeStringField("frequencyUnit", this.frequencyUnit == null ? null : this.frequencyUnit.toString());
        jsonWriter.writeBooleanField("keepAtLeastOneBackup", this.keepAtLeastOneBackup);
        jsonWriter.writeIntField("retentionPeriodInDays", this.retentionPeriodInDays);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        return jsonWriter.writeEndObject();
    }

    public static BackupSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (BackupSchedule)jsonReader.readObject(reader -> {
            BackupSchedule deserializedBackupSchedule = new BackupSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequencyInterval".equals(fieldName)) {
                    deserializedBackupSchedule.frequencyInterval = reader.getInt();
                    continue;
                }
                if ("frequencyUnit".equals(fieldName)) {
                    deserializedBackupSchedule.frequencyUnit = FrequencyUnit.fromString(reader.getString());
                    continue;
                }
                if ("keepAtLeastOneBackup".equals(fieldName)) {
                    deserializedBackupSchedule.keepAtLeastOneBackup = reader.getBoolean();
                    continue;
                }
                if ("retentionPeriodInDays".equals(fieldName)) {
                    deserializedBackupSchedule.retentionPeriodInDays = reader.getInt();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedBackupSchedule.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastExecutionTime".equals(fieldName)) {
                    deserializedBackupSchedule.lastExecutionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupSchedule;
        });
    }
}

