/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.OperationResultProperties;
import com.azure.resourcemanager.appservice.models.RetryHistory;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class OperationResult
extends OperationResultProperties {
    private String trackingId;
    private Object inputs;
    private ContentLink inputsLink;
    private Object outputs;
    private ContentLink outputsLink;
    private Object trackedProperties;
    private List<RetryHistory> retryHistory;
    private Integer iterationCount;

    public String trackingId() {
        return this.trackingId;
    }

    OperationResult withTrackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    public Object inputs() {
        return this.inputs;
    }

    OperationResult withInputs(Object inputs) {
        this.inputs = inputs;
        return this;
    }

    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    OperationResult withInputsLink(ContentLink inputsLink) {
        this.inputsLink = inputsLink;
        return this;
    }

    public Object outputs() {
        return this.outputs;
    }

    OperationResult withOutputs(Object outputs) {
        this.outputs = outputs;
        return this;
    }

    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    OperationResult withOutputsLink(ContentLink outputsLink) {
        this.outputsLink = outputsLink;
        return this;
    }

    public Object trackedProperties() {
        return this.trackedProperties;
    }

    OperationResult withTrackedProperties(Object trackedProperties) {
        this.trackedProperties = trackedProperties;
        return this;
    }

    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    public OperationResult withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    public Integer iterationCount() {
        return this.iterationCount;
    }

    public OperationResult withIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    @Override
    public OperationResult withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    @Override
    public OperationResult withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    @Override
    public OperationResult withCorrelation(RunActionCorrelation correlation) {
        super.withCorrelation(correlation);
        return this;
    }

    @Override
    public OperationResult withStatus(WorkflowStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public OperationResult withCode(String code) {
        super.withCode(code);
        return this;
    }

    @Override
    public OperationResult withError(Object error) {
        super.withError(error);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.retryHistory() != null) {
            this.retryHistory().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime()));
        jsonWriter.writeStringField("endTime", this.endTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime()));
        jsonWriter.writeJsonField("correlation", (JsonSerializable)this.correlation());
        jsonWriter.writeStringField("status", this.status() == null ? null : this.status().toString());
        jsonWriter.writeStringField("code", this.code());
        jsonWriter.writeUntypedField("error", this.error());
        jsonWriter.writeArrayField("retryHistory", this.retryHistory, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("iterationCount", (Number)this.iterationCount);
        return jsonWriter.writeEndObject();
    }

    public static OperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResult)jsonReader.readObject(reader -> {
            OperationResult deserializedOperationResult = new OperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedOperationResult.withStartTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationResult.withEndTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedOperationResult.withCorrelation(RunActionCorrelation.fromJson(reader));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationResult.withStatus(WorkflowStatus.fromString(reader.getString()));
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedOperationResult.withCode(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationResult.withError(reader.readUntyped());
                    continue;
                }
                if ("trackingId".equals(fieldName)) {
                    deserializedOperationResult.trackingId = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    deserializedOperationResult.inputs = reader.readUntyped();
                    continue;
                }
                if ("inputsLink".equals(fieldName)) {
                    deserializedOperationResult.inputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    deserializedOperationResult.outputs = reader.readUntyped();
                    continue;
                }
                if ("outputsLink".equals(fieldName)) {
                    deserializedOperationResult.outputsLink = ContentLink.fromJson(reader);
                    continue;
                }
                if ("trackedProperties".equals(fieldName)) {
                    deserializedOperationResult.trackedProperties = reader.readUntyped();
                    continue;
                }
                if ("retryHistory".equals(fieldName)) {
                    List retryHistory;
                    deserializedOperationResult.retryHistory = retryHistory = reader.readArray(reader1 -> RetryHistory.fromJson(reader1));
                    continue;
                }
                if ("iterationCount".equals(fieldName)) {
                    deserializedOperationResult.iterationCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResult;
        });
    }
}

