/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ScaleRule;
import java.io.IOException;
import java.util.List;

public final class Scale
implements JsonSerializable<Scale> {
    private Integer minReplicas;
    private Integer maxReplicas;
    private List<ScaleRule> rules;

    public Integer minReplicas() {
        return this.minReplicas;
    }

    public Scale withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    public Scale withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    public List<ScaleRule> rules() {
        return this.rules;
    }

    public Scale withRules(List<ScaleRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minReplicas", (Number)this.minReplicas);
        jsonWriter.writeNumberField("maxReplicas", (Number)this.maxReplicas);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Scale fromJson(JsonReader jsonReader) throws IOException {
        return (Scale)jsonReader.readObject(reader -> {
            Scale deserializedScale = new Scale();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minReplicas".equals(fieldName)) {
                    deserializedScale.minReplicas = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxReplicas".equals(fieldName)) {
                    deserializedScale.maxReplicas = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedScale.rules = rules = reader.readArray(reader1 -> ScaleRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScale;
        });
    }
}

