/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CustomScaleRule;
import com.azure.resourcemanager.appservice.models.HttpScaleRule;
import com.azure.resourcemanager.appservice.models.QueueScaleRule;
import java.io.IOException;

public final class ScaleRule
implements JsonSerializable<ScaleRule> {
    private String name;
    private QueueScaleRule azureQueue;
    private CustomScaleRule custom;
    private HttpScaleRule http;

    public String name() {
        return this.name;
    }

    public ScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    public QueueScaleRule azureQueue() {
        return this.azureQueue;
    }

    public ScaleRule withAzureQueue(QueueScaleRule azureQueue) {
        this.azureQueue = azureQueue;
        return this;
    }

    public CustomScaleRule custom() {
        return this.custom;
    }

    public ScaleRule withCustom(CustomScaleRule custom) {
        this.custom = custom;
        return this;
    }

    public HttpScaleRule http() {
        return this.http;
    }

    public ScaleRule withHttp(HttpScaleRule http) {
        this.http = http;
        return this;
    }

    public void validate() {
        if (this.azureQueue() != null) {
            this.azureQueue().validate();
        }
        if (this.custom() != null) {
            this.custom().validate();
        }
        if (this.http() != null) {
            this.http().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("azureQueue", (JsonSerializable)this.azureQueue);
        jsonWriter.writeJsonField("custom", (JsonSerializable)this.custom);
        jsonWriter.writeJsonField("http", (JsonSerializable)this.http);
        return jsonWriter.writeEndObject();
    }

    public static ScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return (ScaleRule)jsonReader.readObject(reader -> {
            ScaleRule deserializedScaleRule = new ScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScaleRule.name = reader.getString();
                    continue;
                }
                if ("azureQueue".equals(fieldName)) {
                    deserializedScaleRule.azureQueue = QueueScaleRule.fromJson(reader);
                    continue;
                }
                if ("custom".equals(fieldName)) {
                    deserializedScaleRule.custom = CustomScaleRule.fromJson(reader);
                    continue;
                }
                if ("http".equals(fieldName)) {
                    deserializedScaleRule.http = HttpScaleRule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleRule;
        });
    }
}

