/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LocalizableString;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CsmUsageQuotaInner
implements JsonSerializable<CsmUsageQuotaInner> {
    private String unit;
    private OffsetDateTime nextResetTime;
    private Long currentValue;
    private Long limit;
    private LocalizableString name;

    public String unit() {
        return this.unit;
    }

    public CsmUsageQuotaInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public OffsetDateTime nextResetTime() {
        return this.nextResetTime;
    }

    public CsmUsageQuotaInner withNextResetTime(OffsetDateTime nextResetTime) {
        this.nextResetTime = nextResetTime;
        return this;
    }

    public Long currentValue() {
        return this.currentValue;
    }

    public CsmUsageQuotaInner withCurrentValue(Long currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public Long limit() {
        return this.limit;
    }

    public CsmUsageQuotaInner withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public LocalizableString name() {
        return this.name;
    }

    public CsmUsageQuotaInner withName(LocalizableString name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("nextResetTime", this.nextResetTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextResetTime));
        jsonWriter.writeNumberField("currentValue", (Number)this.currentValue);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        return jsonWriter.writeEndObject();
    }

    public static CsmUsageQuotaInner fromJson(JsonReader jsonReader) throws IOException {
        return (CsmUsageQuotaInner)jsonReader.readObject(reader -> {
            CsmUsageQuotaInner deserializedCsmUsageQuotaInner = new CsmUsageQuotaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("unit".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.unit = reader.getString();
                    continue;
                }
                if ("nextResetTime".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.nextResetTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.currentValue = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.limit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.name = LocalizableString.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmUsageQuotaInner;
        });
    }
}

