/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SourceControlProperties
implements JsonSerializable<SourceControlProperties> {
    private String token;
    private String tokenSecret;
    private String refreshToken;
    private OffsetDateTime expirationTime;

    public String token() {
        return this.token;
    }

    public SourceControlProperties withToken(String token) {
        this.token = token;
        return this;
    }

    public String tokenSecret() {
        return this.tokenSecret;
    }

    public SourceControlProperties withTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
        return this;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public SourceControlProperties withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public SourceControlProperties withExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeStringField("tokenSecret", this.tokenSecret);
        jsonWriter.writeStringField("refreshToken", this.refreshToken);
        jsonWriter.writeStringField("expirationTime", this.expirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTime));
        return jsonWriter.writeEndObject();
    }

    public static SourceControlProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlProperties)jsonReader.readObject(reader -> {
            SourceControlProperties deserializedSourceControlProperties = new SourceControlProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    deserializedSourceControlProperties.token = reader.getString();
                    continue;
                }
                if ("tokenSecret".equals(fieldName)) {
                    deserializedSourceControlProperties.tokenSecret = reader.getString();
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedSourceControlProperties.refreshToken = reader.getString();
                    continue;
                }
                if ("expirationTime".equals(fieldName)) {
                    deserializedSourceControlProperties.expirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlProperties;
        });
    }
}

